/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.cli;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.recommenders.livedoc.Livedoc;
import org.eclipse.recommenders.livedoc.cli.aether.RepositoryClient;
import org.eclipse.recommenders.livedoc.cli.args4j.CliOptions;
import org.eclipse.recommenders.livedoc.utils.LivedocChecks;
import org.eclipse.recommenders.livedoc.utils.LivedocPreconditionException;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.recommenders.utils.Zips;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements IApplication {
    private static final File TEMP_DIR = new File(FileUtils.getTempDirectory(), "livedoc");
    private static final File SOURCES_TEMP_DIR = new File(TEMP_DIR, "sources");
    private static final File JAVADOC_TEMP_DIR = new File(TEMP_DIR, "javadoc");
    private static final File SOURCEREPO_CACHE_DIR = new File(TEMP_DIR, "sourceRepo/cache");
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    private CliOptions settings;
    private RepositoryClient repoClient;
    private static final Integer EXIT_ERROR = IApplication.EXIT_OK;

    public Object start(IApplicationContext context) throws Exception {
        try {
            LivedocChecks.preconditions((boolean)true);
            this.initializeSettings(this.getArguments(context));
            this.configureLogback();
            this.prepareTempDirectory();
            this.initializeRepositoryClient();
            Artifact sourceArtifact = this.downloadSourcesArtifact(this.settings.getCoordinate(), this.settings.getSourcesRepository());
            List<Artifact> dependencies = this.resolveDependencies(sourceArtifact);
            String outPutFileName = this.outputName(sourceArtifact);
            File sourcesDir = this.unpackSources(sourceArtifact.getFile());
            File tmpOutput = new File(JAVADOC_TEMP_DIR, outPutFileName);
            Artifact modelCoordinate = this.settings.getModelCoordinate() != null ? this.settings.getModelCoordinate() : this.settings.getCoordinate();
            this.generateJavaDoc(modelCoordinate, sourcesDir, tmpOutput, dependencies);
            File output = new File(this.settings.getOutputDir(), this.createDirectoryHierarchy(sourceArtifact));
            output.mkdirs();
            FileUtils.copyDirectory((File)tmpOutput, (File)output);
            if (this.settings.isJarOutput() || this.settings.getJavadocRepository() != null) {
                File jarFile = this.jarOutput(tmpOutput);
                if (this.settings.isJarOutput()) {
                    FileUtils.copyFileToDirectory((File)jarFile, (File)this.settings.getOutputDir());
                }
                if (this.settings.getJavadocRepository() != null) {
                    this.uploadJavadocArtifact(sourceArtifact, jarFile, this.settings.getJavadocRepository());
                }
            }
            System.out.println("Done.");
            return IApplication.EXIT_OK;
        }
        catch (IOException | IllegalArgumentException | LivedocPreconditionException throwable) {
            System.out.println("Failed.");
            return EXIT_ERROR;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            System.out.println("Failed.");
            return EXIT_ERROR;
        }
    }

    private List<Artifact> resolveDependencies(Artifact sourceArtifact) {
        if (this.settings.noDependencies()) {
            return Collections.emptyList();
        }
        try {
            if (this.settings.isTransitive()) {
                return this.repoClient.resolveTransitiveDependencies(sourceArtifact, this.settings.getSourcesRepository());
            }
            return this.repoClient.resolveDirectDependencies(sourceArtifact, this.settings.getSourcesRepository());
        }
        catch (IOException e) {
            LOG.error("Could not resolve any dependencies of source artifact {}", (Object)sourceArtifact, (Object)e);
            return Collections.emptyList();
        }
    }

    private void initializeSettings(String ... args) throws IllegalArgumentException {
        CliOptions settings = new CliOptions();
        CmdLineParser parser = new CmdLineParser((Object)settings);
        parser.setUsageWidth(100);
        try {
            parser.parseArgument(args);
            this.settings = settings;
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("SYNPOSIS:");
            System.err.print(" livedoc-cli");
            parser.printSingleLineUsage((OutputStream)System.err);
            System.err.println();
            System.err.println();
            System.err.println("PARAMETERS:");
            parser.printUsage((OutputStream)System.err);
            throw new IllegalArgumentException(e);
        }
    }

    private void configureLogback() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = lc.getLogger("ROOT");
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)lc);
        appender.setName("STDOUT");
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)lc);
        StringBuilder pattern = new StringBuilder("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        if (!this.settings.isDebug()) {
            pattern.append("%exceptionMessage");
            pattern.append("%nopex");
        }
        pl.setPattern(pattern.toString());
        pl.start();
        appender.setEncoder((Encoder)pl);
        appender.start();
        logger.addAppender((Appender)appender);
    }

    private void initializeRepositoryClient() throws IOException {
        File cacheDir = new File(SOURCEREPO_CACHE_DIR, Urls.mangle((URL)this.settings.getSourcesRepository()));
        cacheDir.mkdirs();
        this.repoClient = new RepositoryClient(cacheDir);
    }

    private String[] getArguments(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length > 0 && args[0].equalsIgnoreCase("-showlocation")) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        return args;
    }

    private Artifact downloadSourcesArtifact(Artifact coordinate, URL remoteRepository) throws IOException {
        if (this.settings.isVerbose()) {
            System.out.printf("Downloading sources for artifact \"%s\".\n", coordinate);
        }
        try {
            SubArtifact sourcesCoordinate = new SubArtifact(coordinate, "sources", "jar");
            return this.repoClient.download((Artifact)sourcesCoordinate, remoteRepository);
        }
        catch (IOException e) {
            System.err.printf("Failed to download sources artifact for \"%s\" (%s).\n", coordinate, e);
            throw e;
        }
    }

    private void uploadJavadocArtifact(Artifact sourceArtifact, File artifactFile, URL remoteRepository) throws IOException {
        if (this.settings.isVerbose()) {
            System.out.printf("Uploading Javadoc for artifact \"%s\".\n", sourceArtifact);
        }
        try {
            SubArtifact uploadArtifact = new SubArtifact(sourceArtifact, "javadoc", "jar");
            uploadArtifact = uploadArtifact.setFile(artifactFile);
            this.repoClient.upload((Artifact)uploadArtifact, remoteRepository);
        }
        catch (IOException e) {
            System.err.printf("Failed to upload Javadoc artifact for \"%s\" (%s).\n", sourceArtifact, e);
            throw e;
        }
    }

    private File jarOutput(File directory) throws IOException {
        String jarFileName = new StringBuffer(directory.getName()).append(".jar").toString();
        File output = new File(directory.getParentFile() + File.separator + jarFileName);
        Zips.zip((File)directory, (File)output);
        return output;
    }

    private String createDirectoryHierarchy(Artifact sourceArtifact) {
        StringBuffer sb = new StringBuffer();
        sb.append(sourceArtifact.getGroupId().replace(".", File.separator)).append(File.separator).append(sourceArtifact.getArtifactId()).append(File.separator).append(sourceArtifact.getBaseVersion());
        return sb.toString();
    }

    private void generateJavaDoc(Artifact modelCoordinate, File sourcesDir, File outputDir, List<Artifact> dependencies) throws IOException, LivedocPreconditionException {
        List<String> subpackages = this.settings.getSubpackages() != null ? this.settings.getSubpackages() : this.filterSourceFiles(sourcesDir);
        Livedoc livedoc = new Livedoc(sourcesDir, outputDir, subpackages, modelCoordinate.getGroupId(), modelCoordinate.getArtifactId(), modelCoordinate.getVersion());
        livedoc.setVerbose(this.settings.isVerbose());
        livedoc.setHighlight(this.settings.isHighlight());
        livedoc.setProviderArguments(this.settings.getProviderArguments());
        livedoc.setSplitIndex(this.settings.isSplitIndex());
        livedoc.setModelRepositories(this.settings.getModelsRepositories());
        livedoc.setEncoding(this.settings.getCharset());
        livedoc.setDoclintOptions(this.settings.getDoclintOptions());
        for (Artifact artifact : dependencies) {
            livedoc.addAdditonalClasspathEntry(artifact.getFile());
        }
        livedoc.generate();
    }

    private String outputName(Artifact artifact) {
        StringBuffer sb = new StringBuffer(artifact.getArtifactId());
        sb.append("-");
        sb.append(artifact.getVersion());
        sb.append("-javadoc");
        return sb.toString();
    }

    private List<String> filterSourceFiles(File sourceFiles) {
        List<File> subpackages = Arrays.asList(sourceFiles.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("META-INF") && file.isDirectory() && !FileUtils.listFiles((File)file, (String[])new String[]{"java"}, (boolean)true).isEmpty();
            }
        }));
        ArrayList<String> result = new ArrayList<String>(subpackages.size());
        for (File file : subpackages) {
            result.add(file.getName());
        }
        return result;
    }

    private File unpackSources(File sourcesJar) throws IOException {
        String fileName = StringUtils.removeEnd((String)sourcesJar.getName(), (String)".jar");
        File destFolder = new File(SOURCES_TEMP_DIR, fileName);
        if (!this.settings.isResume()) {
            Zips.unzip((File)sourcesJar, (File)destFolder);
        }
        return destFolder;
    }

    private void prepareTempDirectory() throws Exception {
        if (this.settings.isResume()) {
            return;
        }
        SOURCEREPO_CACHE_DIR.mkdirs();
        try {
            if (JAVADOC_TEMP_DIR.exists()) {
                FileUtils.cleanDirectory((File)JAVADOC_TEMP_DIR);
            } else {
                JAVADOC_TEMP_DIR.mkdirs();
            }
            if (SOURCES_TEMP_DIR.exists()) {
                FileUtils.cleanDirectory((File)SOURCES_TEMP_DIR);
            } else {
                SOURCES_TEMP_DIR.mkdirs();
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't clear livedoc tmp folders. \n", (Throwable)e);
            throw e;
        }
    }

    public void stop() {
    }
}

