/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.cli.args4j;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.recommenders.livedoc.cli.args4j.ProviderCmdLineArguments;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ProviderArgumentsHandler
extends OptionHandler<ProviderCmdLineArguments> {
    List<String> usedIds = Lists.newLinkedList();

    public ProviderArgumentsHandler(CmdLineParser parser, OptionDef option, Setter<? super ProviderCmdLineArguments> setter) {
        super(parser, option, setter);
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        int i = 0;
        String id = params.getParameter(i);
        if (this.usedIds.contains(id)) {
            throw new CmdLineException(this.owner, String.format("Found duplicate Provider in command line arguments: %s \nPlease make sure you use each Provider only once!", id));
        }
        this.usedIds.add(id);
        LinkedList args = Lists.newLinkedList();
        boolean enclosingbracket = false;
        if (this.checkForAdditionalArguments(params)) {
            i = 1;
            while (i < params.size()) {
                args.add(params.getParameter(i).replaceAll("[\\[\\]]", ""));
                if (params.getParameter(i).endsWith("]")) {
                    enclosingbracket = true;
                    break;
                }
                ++i;
            }
            if (!enclosingbracket) {
                throw new CmdLineException(this.owner, "Did not find expected token ']' after '['");
            }
        }
        this.setter.addValue((Object)new ProviderCmdLineArguments(id, args.toArray(new String[args.size()])));
        return ++i;
    }

    private boolean checkForAdditionalArguments(Parameters params) throws CmdLineException {
        return params.size() > 1 && params.getParameter(1).startsWith("[");
    }

    public String getDefaultMetaVariable() {
        return "PROVIDER_ID [PROVIDER_ARGUMENTS]";
    }
}

