/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.recommenders.livedoc.providers.analytics;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ProjectCoordinate;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;

public class AnalyticsProvider extends AbstractLiveDocProvider<AnalyticsConfiguration> {

    private ProviderOutput providerOutput;

    @Override
    public String getId() {
        return "analytics";
    }

    @Override
    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        providerOutput = createAnalyticsProviderOutput();
    }

    private ProviderOutput createAnalyticsProviderOutput() throws LiveDocProviderException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<script type=\"text/javascript\">");
            String script = IOUtils.toString(getClass().getClassLoader().getResourceAsStream("googleanalytics.js"));
            script = script.replace("$ID$", getConfiguration().getWebPropertyId());
            sb.append(script);
            sb.append("</script>");

            return new ProviderOutput(sb.toString(), 0);
        } catch (IOException e) {
            throw new LiveDocProviderException(String.format(
                    "Error while reading googleanalytics.js script in provider %s.", getId()));
        }
    }

    @Override
    public ProviderOutput documentClass(ClassDoc holder) {
        return providerOutput;
    }

    @Override
    public ProviderOutput documentPackage(PackageDoc holder) {
        return providerOutput;
    }

    @Override
    public ProviderOutput documentOverview(RootDoc holder) {
        return providerOutput;
    }

    @Override
    public AnalyticsConfiguration newProviderConfiguration() {
        return new AnalyticsConfiguration();
    }
}
