/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.recommenders.livedoc.providers.calls;

import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.kohsuke.args4j.Option;

public class ClassSelfCallConfiguration extends ProviderConfiguration {

    @Option(name = "-top")
    private int topNumbers = Integer.MAX_VALUE;

    @Option(name = "-percent")
    private int percentage = 1;

    @Option(name = "-times")
    private int times = 0;

    public int getNumberThreshold() {
        return topNumbers;
    }

    public double getPercentageThreshold() {
        return percentage;
    }

    public Integer getTimesObservedThreshold() {
        return times;
    }

}
