/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.calls;

import com.google.common.base.Optional;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.calls.SingleZipCallModelProvider;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.calls.CallAlsoConfiguration;
import org.eclipse.recommenders.livedoc.utils.ItemBuilder;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.livedoc.utils.MethodDocumentationBuilder;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class CallAlsoProvider
extends AbstractLiveDocProvider<CallAlsoConfiguration> {
    private ICallModelProvider modelProvider;
    private Optional<ICallModel> model;

    public String getId() {
        return "call-also";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        Optional modelArchive = this.fetchModelArchive("call");
        if (!modelArchive.isPresent()) {
            throw new LiveDocProviderException(String.format("No %s model available for given coordinate.", this.getId()));
        }
        this.modelProvider = new SingleZipCallModelProvider((File)modelArchive.get());
        try {
            this.modelProvider.open();
        }
        catch (IOException iOException) {
            throw new LiveDocProviderException(String.format("Exception while opening model provider for %s models.", this.getId()));
        }
    }

    public void beginClass(ClassDoc newClassDoc) {
        ITypeName methodDeclaringType = LiveDocUtils.extractTypeName((Doc)newClassDoc);
        UniqueTypeName uniqueTypeName = new UniqueTypeName(this.getProjectCoordinate(), methodDeclaringType);
        this.model = this.modelProvider.acquireModel((IUniqueName)uniqueTypeName);
    }

    public void endClass(ClassDoc oldClassDoc) {
        if (this.model.isPresent()) {
            this.modelProvider.releaseModel((Object)((ICallModel)this.model.get()));
        }
    }

    public ProviderOutput documentMethod(MethodDoc holder) {
        if (!holder.isStatic()) {
            return this.generateMethodDoc(holder);
        }
        return null;
    }

    private ProviderOutput generateMethodDoc(MethodDoc holder) {
        if (this.model.isPresent()) {
            IMethodName currentMethod = LiveDocUtils.asIMethodName((MethodDoc)holder);
            ((ICallModel)this.model.get()).reset();
            if (this.methodsInObservedState((ICallModel)this.model.get(), Collections.singleton(currentMethod))) {
                List recommendations = ((ICallModel)this.model.get()).recommendCalls();
                if (!(recommendations = LiveDocUtils.topMethods((Iterable)recommendations, (int)((CallAlsoConfiguration)this.getConfiguration()).getNumberThreshold(), (double)(((CallAlsoConfiguration)this.getConfiguration()).getPercentageThreshold() / 100.0))).isEmpty()) {
                    MethodDocumentationBuilder mdb = MethodDocumentationBuilder.create().title("Call Also:").description("People who called " + LiveDocUtils.code((String)holder.name()) + " also called:").beginList(MethodDocumentationBuilder.ListType.SEQUENTIAL);
                    for (Recommendation recommendation : recommendations) {
                        mdb.addItem(ItemBuilder.create((MethodDoc)holder).method((IMethodName)recommendation.getProposal()).withPercentage(recommendation.getRelevance() * 100.0).build());
                    }
                    mdb.endList();
                    return new ProviderOutput(this.highlight(mdb.build()), recommendations.size());
                }
            }
        }
        return null;
    }

    private boolean methodsInObservedState(ICallModel model, Set<IMethodName> methods) {
        return model.setObservedCalls(methods);
    }

    public void tearDown() throws LiveDocProviderException {
        if (this.modelProvider != null) {
            try {
                this.modelProvider.close();
            }
            catch (IOException iOException) {
                throw new LiveDocProviderException(String.format("Exception while closing model provider for %s models.", this.getId()));
            }
        }
    }

    public CallAlsoConfiguration newProviderConfiguration() {
        return new CallAlsoConfiguration();
    }
}

