/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.calls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.apidocs.ClassSelfcallDirectives;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.calls.ClassSelfCallConfiguration;
import org.eclipse.recommenders.livedoc.providers.calls.SingleZipClassSelfCallsModelProvider;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ClassSelfCallProvider
extends AbstractLiveDocProvider<ClassSelfCallConfiguration> {
    private IModelProvider<UniqueTypeName, ClassSelfcallDirectives> modelProvider;
    private Optional<ClassSelfcallDirectives> model;

    public String getId() {
        return "selfc";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        Optional modelArchive = this.fetchModelArchive("selfc");
        if (!modelArchive.isPresent()) {
            throw new LiveDocProviderException(String.format("No %s model available for given coordinate.", this.getId()));
        }
        this.modelProvider = new SingleZipClassSelfCallsModelProvider((File)modelArchive.get());
        try {
            this.modelProvider.open();
        }
        catch (IOException iOException) {
            throw new LiveDocProviderException(String.format("Exception while opening model provider for %s models.", this.getId()));
        }
    }

    @VisibleForTesting
    void setUp(ProjectCoordinate pc, IModelProvider<UniqueTypeName, ClassSelfcallDirectives> modelProvider) throws LiveDocProviderException {
        super.setUp(pc, null, null);
        this.modelProvider = modelProvider;
    }

    public void beginClass(ClassDoc newClassDoc) {
        ITypeName methodDeclaringType = LiveDocUtils.extractTypeName((Doc)newClassDoc);
        UniqueTypeName uniqueTypeName = new UniqueTypeName(this.getProjectCoordinate(), methodDeclaringType);
        this.model = this.modelProvider.acquireModel((IUniqueName)uniqueTypeName);
    }

    public ProviderOutput documentClass(ClassDoc holder) {
        if (!this.model.isPresent()) {
            return null;
        }
        List<Map.Entry<IMethodName, Integer>> recommendations = this.preprocessEntries((ClassSelfcallDirectives)this.model.get());
        if (recommendations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h5>").append("Self Calls:").append("</h5>");
        sb.append("<p>").append("The following methods are frequently called by implementors of ").append(LiveDocUtils.code((String)holder.name())).append(":").append("</p>");
        sb.append("<ul>");
        Iterator<Map.Entry<IMethodName, Integer>> it = recommendations.iterator();
        while (it.hasNext()) {
            Map.Entry<IMethodName, Integer> entry = it.next();
            IMethodName method = entry.getKey();
            float percentage = this.calculatePercentage(((ClassSelfcallDirectives)this.model.get()).getNumberOfSubclasses(), entry);
            sb.append("<li>");
            sb.append("<code>");
            sb.append((CharSequence)LiveDocUtils.strong((StringBuilder)LiveDocUtils.htmlLink((IMethodName)method))).append(LiveDocUtils.listParameterTypes((IMethodName)method));
            sb.append("</code>");
            sb.append(String.format(" (<font color=\"#0000FF\">%1$.0f%% - %2$d times</font>)", Float.valueOf(percentage), entry.getValue()));
            if (it.hasNext()) {
                sb.append(", ");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        return new ProviderOutput(this.highlight(sb).toString(), recommendations.size());
    }

    public void endClass(ClassDoc oldClassDoc) {
        if (this.model.isPresent()) {
            this.modelProvider.releaseModel((Object)((ClassSelfcallDirectives)this.model.get()));
        }
    }

    public void tearDown() throws LiveDocProviderException {
        if (this.modelProvider != null) {
            try {
                this.modelProvider.close();
            }
            catch (IOException iOException) {
                throw new LiveDocProviderException(String.format("Exception while closing model provider for %s models.", this.getId()));
            }
        }
    }

    private List<Map.Entry<IMethodName, Integer>> preprocessEntries(ClassSelfcallDirectives directive) {
        List<Map.Entry<IMethodName, Integer>> entries = this.sortEntries(directive.getCalls().entrySet());
        entries = this.filterByNumberThreshold(entries);
        entries = this.filterByPercentageAndTimesObservedThreshold(entries, directive.getNumberOfSubclasses());
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> sortEntries(Set<Map.Entry<IMethodName, Integer>> entrySet) {
        ArrayList entries = Lists.newArrayList(entrySet);
        Collections.sort(entries, new Comparator<Map.Entry<IMethodName, Integer>>(){

            @Override
            public int compare(Map.Entry<IMethodName, Integer> o1, Map.Entry<IMethodName, Integer> o2) {
                return ComparisonChain.start().compare((Comparable)o2.getValue(), (Comparable)o1.getValue()).compare((Comparable)((Object)o1.getKey().getName()), (Comparable)((Object)o2.getKey().getName())).result();
            }
        });
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> filterByNumberThreshold(List<Map.Entry<IMethodName, Integer>> entries) {
        int numberThreshold = ((ClassSelfCallConfiguration)this.getConfiguration()).getNumberThreshold();
        if (entries.size() > numberThreshold) {
            return entries.subList(0, numberThreshold);
        }
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> filterByPercentageAndTimesObservedThreshold(List<Map.Entry<IMethodName, Integer>> entries, int numberOfDefinitions) {
        ArrayList filterd = Lists.newArrayList();
        for (Map.Entry<IMethodName, Integer> entry : entries) {
            Integer times = entry.getValue();
            if (times < ((ClassSelfCallConfiguration)this.getConfiguration()).getTimesObservedThreshold() || !((double)this.calculatePercentage(numberOfDefinitions, entry) >= ((ClassSelfCallConfiguration)this.getConfiguration()).getPercentageThreshold())) continue;
            filterd.add(entry);
        }
        return filterd;
    }

    private int calculatePercentage(int numberOfDefinitions, Map.Entry<IMethodName, Integer> entry) {
        return Math.round((float)entry.getValue().intValue() * 100.0f / (float)numberOfDefinitions);
    }

    public ClassSelfCallConfiguration newProviderConfiguration() {
        return new ClassSelfCallConfiguration();
    }
}

