/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.overrides;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.overrides.OverrideMethodsConfiguration;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.SingleZipOverrideModelProvider;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class OverrideMethodsProvider
extends AbstractLiveDocProvider<OverrideMethodsConfiguration> {
    private SingleZipOverrideModelProvider modelProvider;
    private Optional<IOverrideModel> model;
    private HashMap<IOverrideModel, List<Recommendation<IMethodName>>> filteredMap;

    public String getId() {
        return "ovrm";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        Optional modelArchive = this.fetchModelArchive("ovrm");
        if (!modelArchive.isPresent()) {
            throw new LiveDocProviderException(String.format("No %s model available for given coordinate.", this.getId()));
        }
        this.modelProvider = new SingleZipOverrideModelProvider((File)modelArchive.get());
        try {
            this.modelProvider.open();
        }
        catch (IOException iOException) {
            throw new LiveDocProviderException(String.format("Exception while opening model provider for %s models.", this.getId()));
        }
        this.filteredMap = Maps.newHashMapWithExpectedSize((int)this.modelProvider.acquireableTypes().size());
    }

    public void beginClass(ClassDoc newClassDoc) {
        ITypeName typeName = LiveDocUtils.extractTypeName((Doc)newClassDoc);
        this.model = this.ovrmModel(typeName);
    }

    public void endClass(ClassDoc oldClassDoc) {
        if (this.model.isPresent()) {
            this.modelProvider.releaseModel((IOverrideModel)this.model.get());
        }
    }

    public ProviderOutput documentClass(ClassDoc holder) {
        if (this.model.isPresent() && this.filteredNotNull((IOverrideModel)this.model.get())) {
            ITypeName typeName = LiveDocUtils.extractTypeName((Doc)holder);
            StringBuilder sb = new StringBuilder();
            List<Recommendation<IMethodName>> recommendOverrides = this.sortAndFilter((IOverrideModel)this.model.get());
            sb.append("<h5>Method override recommendations</h5>").append("The following methods are frequently overridden by subclasses of ").append("<code>").append(typeName.getClassName()).append("</code>").append(":").append("<br>").append("<br>").append("<ul>");
            Iterator<Recommendation<IMethodName>> iterator = recommendOverrides.iterator();
            while (iterator.hasNext()) {
                Recommendation<IMethodName> recommendation = iterator.next();
                int relevance = Recommendations.asPercentage(recommendation);
                IMethodName method = (IMethodName)recommendation.getProposal();
                sb.append("<li>");
                sb.append("<code>");
                sb.append((CharSequence)LiveDocUtils.strong((StringBuilder)LiveDocUtils.htmlLink((IMethodName)method))).append(LiveDocUtils.listParameterTypes((IMethodName)method));
                sb.append("</code>");
                sb.append(" - ").append("<font color=\"#0000FF\">").append(String.valueOf(relevance) + "%").append("</font>");
                if (iterator.hasNext()) {
                    sb.append(", ");
                }
                sb.append("</li>");
            }
            sb.append("</ul>");
            this.highlight(sb);
            return new ProviderOutput(sb.toString(), recommendOverrides.size());
        }
        return null;
    }

    public ProviderOutput documentMethod(MethodDoc holder) {
        if (!holder.isAbstract()) {
            return this.generateMethodDoc(holder);
        }
        return null;
    }

    private ProviderOutput generateMethodDoc(MethodDoc methodDoc) {
        if (this.model.isPresent() && this.filteredNotNull((IOverrideModel)this.model.get())) {
            ITypeName methodDeclaringType = LiveDocUtils.extractTypeName((Doc)methodDoc);
            StringBuilder sb = new StringBuilder();
            List<Recommendation<IMethodName>> recommendations = this.sortAndFilter((IOverrideModel)this.model.get());
            int relevance = 0;
            for (Recommendation<IMethodName> recommendation : recommendations) {
                if (!LiveDocUtils.methodSignatureEquals((IMethodName)((IMethodName)recommendation.getProposal()), (MethodDoc)methodDoc)) continue;
                relevance = Recommendations.asPercentage(recommendation);
                sb.append("<dl>").append("<dt>Method override recommendation:</dt>").append("<dd>").append("Subclasses of ").append(methodDeclaringType.getClassName()).append(" ");
                sb.append(this.percentageToRecommendationPhrase(relevance));
                sb.append(" override this method ").append("(").append("<font color=\"#0000FF\">").append(String.valueOf(relevance) + "%").append("</font>").append(")").append("</dd>").append("</dl>");
                this.highlight(sb);
                break;
            }
            return new ProviderOutput(sb.toString(), recommendations.size());
        }
        return null;
    }

    private String percentageToRecommendationPhrase(int percentage) {
        if (percentage >= 95) {
            return "always";
        }
        if (percentage >= 65) {
            return "usually";
        }
        if (percentage >= 25) {
            return "sometimes";
        }
        if (percentage >= 10) {
            return "occasionally";
        }
        return "rarely";
    }

    private boolean filteredNotNull(IOverrideModel model) {
        List<Recommendation<IMethodName>> filteres = this.sortAndFilter(model);
        return !filteres.isEmpty();
    }

    private List<Recommendation<IMethodName>> sortAndFilter(IOverrideModel model) {
        if (this.filteredMap.containsKey(model)) {
            return this.filteredMap.get(model);
        }
        List recommendations = model.recommendOverrides();
        List filteredList = LiveDocUtils.topMethods((Iterable)recommendations, (int)((OverrideMethodsConfiguration)this.getConfiguration()).getNumberThreshold(), (double)(((OverrideMethodsConfiguration)this.getConfiguration()).getPercentageThreshold() / 100.0));
        this.filteredMap.put(model, filteredList);
        return filteredList;
    }

    private Optional<IOverrideModel> ovrmModel(ITypeName typeName) {
        UniqueTypeName key = new UniqueTypeName(this.getProjectCoordinate(), typeName);
        Optional model = this.modelProvider.acquireModel((IUniqueName)key);
        return model;
    }

    public void tearDown() throws LiveDocProviderException {
        if (this.modelProvider != null) {
            try {
                this.modelProvider.close();
            }
            catch (IOException e) {
                throw new LiveDocProviderException(String.format("Exception while closing model provider for %s models.", this.getId()), (Throwable)e);
            }
        }
    }

    public OverrideMethodsConfiguration newProviderConfiguration() {
        return new OverrideMethodsConfiguration();
    }
}

