/**
 * Copyright (c) 2010, 2014 Darmstadt University of Technology.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andreas Sewe - initial API and implementation.
 */
package org.eclipse.recommenders.internal.livedoc.javadoc;

import java.io.File;
import java.util.List;

import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;

public class CompositeModelRepository implements IModelRepository {

    private final List<IModelRepository> componentRepositories;

    public CompositeModelRepository(Iterable<IModelRepository> componentRepositories) {
        this.componentRepositories = Lists.newArrayList(componentRepositories);
    }

    @Override
    public Optional<File> getLocation(ModelCoordinate mc, boolean prefetch) {
        for (IModelRepository componentRepository : componentRepositories) {
            Optional<File> location = componentRepository.getLocation(mc, prefetch);
            if (location.isPresent()) {
                return location;
            }
        }
        return Optional.absent();
    }

    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force) {
        for (IModelRepository componentRepository : componentRepositories) {
            Optional<File> model = componentRepository.resolve(mc, force);
            if (model.isPresent()) {
                return model;
            }
        }
        return Optional.absent();
    }

    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force, DownloadCallback callback) {
        for (IModelRepository componentRepository : componentRepositories) {
            Optional<File> model = componentRepository.resolve(mc, force, callback);
            if (model.isPresent()) {
                return model;
            }
        }
        return Optional.absent();
    }
}
