/**
 * Copyright (c) 2013 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick Gottschaemmer - initial API and implementation.
 */
package org.eclipse.recommenders.livedoc.utils;

import java.util.Arrays;
import java.util.List;

import com.google.common.collect.Lists;

public class HtmlUtils {

    public static String grey(String textToGrey) {
        return "<font color=\"#808080\">".concat(textToGrey).concat("</font>");
    }

    public static class HtmlTable {
        private String title;
        private List<String> columns = Lists.newLinkedList();
        private List<List<String>> rows = Lists.newLinkedList();
        private String htmlClass;
        private String summary;

        public HtmlTable(String title, String htmlClass, String summary) {
            this.title = title;
            this.htmlClass = htmlClass;
            this.summary = summary;
        }

        public void addColumn(String columnTitle) {
            this.columns.add(columnTitle);
        }

        public void addRow(String... elements) {
            rows.add(Arrays.asList(elements));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();

            sb.append("<table class=\"")
                    .append(htmlClass)
                    .append("\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\" summary=\"")
                    .append(summary)
                    .append("\"><caption><span>")
                    .append(title)
                    .append("</span><span class=\"tabEnd\">&nbsp;</span></caption>");

            sb.append("<thead>")
                    .append("<tr>");

            for (String column : columns) {
                sb.append("<th class=\"colFirst\" scope=\"col\">")
                        .append(column)
                        .append("</th>");
            }
            sb.append("</tr>")
                    .append("</thead>")
                    .append("<tbody>");

            boolean altColor = true;
            for (List<String> columns : rows) {
                if (altColor == true) {
                    sb.append("<tr class=\"altColor\">");
                    altColor = false;
                } else {
                    sb.append("<tr class=\"rowColor\">");
                    altColor = true;
                }
                for (String element : columns) {
                    sb.append("<td class=\"colFirst\">");

                    if (columns.indexOf(element) == 0) {
                        sb.append(element);
                    } else {
                        sb.append("<div class=\"block\">")
                                .append(element)
                                .append("</div>");
                    }
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }

            sb.append("</tbody>")
                    .append("</table>");
            return sb.toString();
        }
    }
}
