/**
 * Copyright (c) 2010, 2013 Darmstadt University of Technology.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Olav Lenz - initial API and implementation.
 */
package org.eclipse.recommenders.livedoc.utils;

import static org.eclipse.recommenders.livedoc.utils.LiveDocUtils.*;

import org.eclipse.recommenders.utils.names.IMethodName;

import com.sun.javadoc.MethodDoc;

public class ItemBuilder {

    private static final String SPACE = " ";

    private MethodDoc holder;
    private StringBuilder sb = new StringBuilder();

    public ItemBuilder(MethodDoc holder) {
        this.holder = holder;
    }

    public static ItemBuilder create(MethodDoc holder) {
        return new ItemBuilder(holder);
    }

    public ItemBuilder method(IMethodName methodName) {
        sb.append(CODE).append(strong(htmlLink(holder.containingClass(), methodName)))
                .append(listParameterTypes(methodName)).append(CODE_END).append(SPACE);
        return this;
    }

    public ItemBuilder string(String string) {
        sb.append(string).append(SPACE);
        return this;
    }

    public ItemBuilder withPercentage(double percentage) {
        sb.append(String.format("(<font color=\"#0000FF\">%1$.0f%%</font>)", percentage)).append(SPACE);
        return this;
    }

    public ItemBuilder withTimesAndPercentage(double percentage, int times) {
        sb.append(String.format("(<font color=\"#0000FF\">%1$.0f%% - %2$d times</font>)", percentage, times)).append(
                SPACE);
        return this;
    }

    public String build() {
        return sb.toString();
    }

}
