/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.livedoc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.livedoc.IProviderManager;
import org.eclipse.recommenders.livedoc.providers.ILivedocProvider;
import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginProviderManager
implements IProviderManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.recommenders.livedoc.providers";
    private static final Logger LOG = LoggerFactory.getLogger(PluginProviderManager.class);
    private List<ILivedocProvider<?>> providers;

    @Override
    public List<ILivedocProvider<?>> loadProviders(Map<String, String[]> providerArguments) {
        Object[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.providers = this.createProviders(Lists.newArrayList((Object[])elements), this.optionalProviderConfigurations(providerArguments));
        return this.providers;
    }

    private Optional<Map<String, String[]>> optionalProviderConfigurations(Map<String, String[]> providerArguments) {
        if (providerArguments == null || providerArguments.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(providerArguments);
    }

    private List<ILivedocProvider<?>> createProviders(List<IConfigurationElement> elements, Optional<Map<String, String[]>> providerArguments) {
        ArrayList providers = new ArrayList(elements.size());
        ImmutableMap elementsMap = Maps.uniqueIndex(elements, (Function)new Function<IConfigurationElement, String>(){

            public String apply(IConfigurationElement input) {
                return input.getAttribute("id");
            }
        });
        elements = this.filterIConfigurationElements((Map<String, IConfigurationElement>)elementsMap, providerArguments);
        for (IConfigurationElement element : elements) {
            try {
                ILivedocProvider provider = (ILivedocProvider)element.createExecutableExtension("class");
                ((ProviderConfiguration)provider.getConfiguration()).setName(element.getAttribute("name"));
                providers.add(provider);
            }
            catch (CoreException e) {
                LOG.error("Couldn't load Provider \"{}\"", (Object)element.getAttribute("id"), (Object)e);
            }
        }
        if (providerArguments.isPresent()) {
            Map providerArgsMap = (Map)providerArguments.get();
            for (ILivedocProvider iLivedocProvider : providers) {
                iLivedocProvider.setArguments((String[])providerArgsMap.get(iLivedocProvider.getId()));
            }
        }
        Collections.sort(providers);
        return providers;
    }

    private List<IConfigurationElement> filterIConfigurationElements(Map<String, IConfigurationElement> elementsMap, Optional<Map<String, String[]>> providerArguments) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(elementsMap.size());
        if (providerArguments.isPresent()) {
            for (String id : ((Map)providerArguments.get()).keySet()) {
                if (elementsMap.containsKey(id)) {
                    result.add(elementsMap.get(id));
                    continue;
                }
                LOG.error("Unknown provider \"{}\", skipping it.\n \t Known Providers are:\n \t \t {}", (Object)id, (Object)Joiner.on((String)", ").join(elementsMap.keySet()));
            }
            return result;
        }
        for (IConfigurationElement provider : elementsMap.values()) {
            if (!this.loadByDefault(provider)) continue;
            result.add(provider);
        }
        return result;
    }

    private boolean loadByDefault(IConfigurationElement provider) {
        String loadByDefault = provider.getAttribute("loadByDefault");
        return loadByDefault == null || loadByDefault.equals("true");
    }

    @Override
    public List<String> getProviderIds() {
        return Lists.transform(this.providers, (Function)new Function<ILivedocProvider<?>, String>(){

            public String apply(ILivedocProvider<?> input) {
                return input.getId();
            }
        });
    }

    @Override
    public List<ILivedocProvider<?>> getProviders() {
        return this.providers;
    }
}

