/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.livedoc.javadoc;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;

public class CompositeModelRepository
implements IModelRepository {
    private final List<IModelRepository> componentRepositories;

    public CompositeModelRepository(Iterable<IModelRepository> componentRepositories) {
        this.componentRepositories = Lists.newArrayList(componentRepositories);
    }

    public Optional<File> getLocation(ModelCoordinate mc, boolean prefetch) {
        for (IModelRepository componentRepository : this.componentRepositories) {
            Optional location = componentRepository.getLocation(mc, prefetch);
            if (!location.isPresent()) continue;
            return location;
        }
        return Optional.absent();
    }

    public Optional<File> resolve(ModelCoordinate mc, boolean force) {
        for (IModelRepository componentRepository : this.componentRepositories) {
            Optional model = componentRepository.resolve(mc, force);
            if (!model.isPresent()) continue;
            return model;
        }
        return Optional.absent();
    }

    public Optional<File> resolve(ModelCoordinate mc, boolean force, DownloadCallback callback) {
        for (IModelRepository componentRepository : this.componentRepositories) {
            Optional model = componentRepository.resolve(mc, force, callback);
            if (!model.isPresent()) continue;
            return model;
        }
        return Optional.absent();
    }
}

