/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.livedoc.javadoc;

import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.standard.Standard;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.recommenders.internal.livedoc.IProviderManager;
import org.eclipse.recommenders.internal.livedoc.PluginProviderManager;
import org.eclipse.recommenders.internal.livedoc.javadoc.RecommendersTaglet;
import org.eclipse.recommenders.internal.livedoc.javadoc.RecommendersTagletException;
import org.eclipse.recommenders.livedoc.providers.ILivedocProvider;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendersDoclet
extends Standard {
    private static HtmlDoclet doclet;
    private static RecommendersDoclet instance;
    private IProviderManager manager = new PluginProviderManager();
    private List<ILivedocProvider<?>> livedocProviders;
    private static Logger LOG;
    private List<URL> modelRepositories;
    private boolean highlight;
    private ProjectCoordinate projectCoordinate;

    static {
        LOG = LoggerFactory.getLogger(RecommendersDoclet.class);
    }

    private RecommendersDoclet() {
    }

    public static RecommendersDoclet instance() {
        if (instance == null) {
            instance = new RecommendersDoclet();
        }
        return instance;
    }

    public static boolean start(RootDoc root) {
        try {
            doclet = new HtmlDoclet();
            Configuration conf = doclet.configuration();
            conf.root = root;
            conf.setOptions();
            RecommendersDoclet.instance().configureRecommendersTaglet();
            return doclet.start((AbstractDoclet)doclet, root);
        }
        catch (Exception e) {
            LOG.error("Execution of RecommendersDoclet failed:", (Throwable)e);
            return false;
        }
    }

    private void configureRecommendersTaglet() {
        this.livedocProviders = this.manager.getProviders();
        RecommendersTaglet taglet = new RecommendersTaglet(this.projectCoordinate, this.modelRepositories, this.livedocProviders, this.highlight);
        try {
            taglet.setUp();
        }
        catch (RecommendersTagletException e) {
            LOG.error("RecommendersTaglet couldn't be successfully initiated. Generating plain Javadoc", (Throwable)e);
            return;
        }
        RecommendersDoclet.doclet.configuration.tagletManager.addCustomTag((Taglet)taglet);
    }

    public void setProjectCoordinate(ProjectCoordinate projectCoordinate) {
        this.projectCoordinate = projectCoordinate;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public void setModelRepositories(List<URL> modelRepositories) {
        this.modelRepositories = modelRepositories;
    }

    public List<String> getProviderIds() {
        return this.manager.getProviderIds();
    }

    public void loadProviders(Map<String, String[]> providerArguments) {
        this.manager.loadProviders(providerArguments);
    }
}

