/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.livedoc.javadoc;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.taglets.BaseTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.recommenders.internal.livedoc.ModelRepoException;
import org.eclipse.recommenders.internal.livedoc.javadoc.CompositeModelIndex;
import org.eclipse.recommenders.internal.livedoc.javadoc.CompositeModelRepository;
import org.eclipse.recommenders.internal.livedoc.javadoc.RecommendersTagletException;
import org.eclipse.recommenders.livedoc.providers.ILivedocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.utils.HtmlUtils;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelIndex;
import org.eclipse.recommenders.models.ModelRepository;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.recommenders.utils.Zips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendersTaglet
extends BaseTaglet {
    private static final String NAME = "recommenders";
    private static final String XMARK = "&#x2717;";
    private static final File TEMP_DIR = new File(FileUtils.getTempDirectory(), "livedoc");
    private static final File MODELSREPO_CACHE_DIR = new File(TEMP_DIR, "modelsRepo/cache");
    private static final File MODELSREPO_INDEX_DIR = new File(TEMP_DIR, "modelsRepo/indexes");
    private static final Logger LOG = LoggerFactory.getLogger(RecommendersTaglet.class);
    private final ProjectCoordinate projectCoordinate;
    private final List<URL> modelRepositoryURLs;
    private final List<ILivedocProvider<?>> providers;
    private final boolean highlight;
    private IModelRepository compositeModelRepository;
    private IModelIndex compositeModelIndex;
    private PackageDoc currentPackageDoc;
    private ClassDoc currentClassDoc;
    private AnnotationTypeDoc currentAnnotationTypeDoc;

    public RecommendersTaglet(ProjectCoordinate pc, List<URL> modelRepositoryURLs, List<ILivedocProvider<?>> providers, boolean highlight) {
        this.projectCoordinate = pc;
        this.modelRepositoryURLs = modelRepositoryURLs;
        this.providers = providers;
        this.highlight = highlight;
    }

    public String getName() {
        return NAME;
    }

    public void setUp() throws RecommendersTagletException {
        try {
            this.prepareModelIndexAndRepo();
        }
        catch (ModelRepoException e) {
            LOG.error("Couldn't prepare model repository, skipping Livedoc providers.", (Throwable)e);
            throw new RecommendersTagletException(e);
        }
        Iterator<ILivedocProvider<?>> it = this.providers.iterator();
        while (it.hasNext()) {
            ILivedocProvider<?> provider = it.next();
            try {
                provider.setUp(this.projectCoordinate, this.compositeModelRepository, this.compositeModelIndex);
                ((ProviderConfiguration)provider.getConfiguration()).setHighlight(this.highlight);
            }
            catch (LiveDocProviderException e) {
                it.remove();
                LOG.error("Provider \"{}\" couldn't be set up, skipping it.", (Object)provider.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    private void prepareModelIndexAndRepo() throws ModelRepoException {
        MODELSREPO_CACHE_DIR.mkdirs();
        MODELSREPO_INDEX_DIR.mkdirs();
        ArrayList componentModelRepositories = Lists.newArrayList();
        ArrayList componentModelIndexes = Lists.newArrayList();
        for (URL url : this.modelRepositoryURLs) {
            File repo = new File(MODELSREPO_CACHE_DIR, Urls.mangle((String)url.toString()));
            try {
                ModelRepository modelRepository = new ModelRepository(repo, url.toExternalForm());
                componentModelRepositories.add(modelRepository);
                Optional zippedIndex = modelRepository.resolve(IModelIndex.INDEX, false);
                if (!zippedIndex.isPresent()) continue;
                ModelIndex index = null;
                try {
                    File indexDir = new File(MODELSREPO_INDEX_DIR, Urls.mangle((String)url.toString()));
                    indexDir.mkdir();
                    Zips.unzip((File)((File)zippedIndex.get()), (File)indexDir);
                    index = new ModelIndex(indexDir);
                    index.open();
                    componentModelIndexes.add(index);
                }
                catch (IOException e) {
                    LOG.warn("No Code Recommenders index available for repository \"{}\".", (Object)url, (Object)e);
                }
            }
            catch (Exception e) {
                throw new ModelRepoException(e);
            }
        }
        this.compositeModelRepository = new CompositeModelRepository(componentModelRepositories);
        this.compositeModelIndex = new CompositeModelIndex(componentModelIndexes);
    }

    public Content getTagletOutput(Doc holder, TagletWriter writer) throws IllegalArgumentException {
        if (holder instanceof RootDoc) {
            return this.aggreagteOverviewDoc((RootDoc)holder, writer);
        }
        if (holder instanceof PackageDoc) {
            return this.aggregatePackageDoc((PackageDoc)holder, writer);
        }
        if (this.classOrInterface(holder)) {
            return this.aggregateClassDoc((ClassDoc)holder, writer);
        }
        if (holder.isField()) {
            return this.aggregateFieldDoc((FieldDoc)holder, writer);
        }
        if (holder.isConstructor()) {
            return this.aggregateConstructorDoc((ConstructorDoc)holder, writer);
        }
        if (holder.isMethod()) {
            return this.aggregateMethodDoc((MethodDoc)holder, writer);
        }
        if (holder.isAnnotationType()) {
            return this.aggregateAnnotationTypeDoc((AnnotationTypeDoc)holder, writer);
        }
        if (holder.isAnnotationTypeElement()) {
            return this.aggregateAnnotationTypeElementDoc((AnnotationTypeElementDoc)holder, writer);
        }
        return null;
    }

    private Content aggreagteOverviewDoc(RootDoc holder, TagletWriter writer) {
        return this.output(writer, this.callProviders(provider -> provider.documentOverview(holder)));
    }

    private Content aggregatePackageDoc(PackageDoc holder, TagletWriter writer) {
        this.newHolderLifecycle(holder, this.currentPackageDoc, new IDocLifecycle<PackageDoc>(){

            @Override
            public void endDoc(PackageDoc oldDoc, ILivedocProvider<?> provider) {
                provider.endPackage(oldDoc);
            }

            @Override
            public void beginDoc(PackageDoc newDoc, ILivedocProvider<?> provider) {
                provider.beginPackage(newDoc);
            }
        });
        this.currentPackageDoc = holder;
        HtmlUtils.HtmlTable table = new HtmlUtils.HtmlTable("Code Recommenders Summary", "typeSummary", "Code Recommenders Summary table, listing Code Recommendations for Types");
        table.addColumn("Class");
        Object[] classDocs = holder.allClasses();
        ArrayList providers = Lists.newArrayList(this.providers);
        Iterables.removeIf((Iterable)providers, (Predicate)new Predicate<ILivedocProvider<?>>(){

            public boolean apply(ILivedocProvider<?> provider) {
                return provider.getId().equals("analytics");
            }
        });
        Arrays.sort(classDocs);
        int i = 0;
        while (i < classDocs.length) {
            Object classDoc = classDocs[i];
            String[] row = new String[providers.size() + 1];
            row[0] = LiveDocUtils.htmlLink((ClassDoc)classDoc).toString();
            int y = 1;
            boolean recommendations = false;
            for (ILivedocProvider provider2 : providers) {
                if (i == 0) {
                    table.addColumn(((ProviderConfiguration)provider2.getConfiguration()).getName());
                }
                provider2.beginClass((ClassDoc)classDoc);
                ProviderOutput output = provider2.documentClass((ClassDoc)classDoc);
                if (output != null) {
                    row[y] = this.prettyPrintNumber(output.getNumberOfRecommendations());
                    recommendations = true;
                } else {
                    int count = 0;
                    MethodDoc[] methodDocArray = classDoc.methods();
                    int n = methodDocArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodDoc method = methodDocArray[n2];
                        output = provider2.documentMethod(method);
                        if (output != null) {
                            ++count;
                        }
                        ++n2;
                    }
                    if (count != 0) {
                        row[y] = this.prettyPrintNumber(count);
                        recommendations = true;
                    } else {
                        row[y] = HtmlUtils.grey(XMARK);
                    }
                }
                provider2.endClass((ClassDoc)classDoc);
                ++y;
            }
            if (recommendations) {
                table.addRow(row);
                recommendations = false;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder(table.toString());
        sb.append(this.callProviders(provider -> provider.documentPackage(holder)));
        return this.output(writer, sb.toString());
    }

    private String prettyPrintNumber(int number) {
        StringBuilder sb = new StringBuilder(Integer.toString(number));
        return LiveDocUtils.strong(sb).toString();
    }

    private Content aggregateClassDoc(ClassDoc holder, TagletWriter writer) {
        this.newHolderLifecycle(holder, this.currentClassDoc, new IDocLifecycle<ClassDoc>(){

            @Override
            public void beginDoc(ClassDoc newDoc, ILivedocProvider<?> provider) {
                provider.beginClass(newDoc);
            }

            @Override
            public void endDoc(ClassDoc oldDoc, ILivedocProvider<?> provider) {
                provider.endClass(oldDoc);
            }
        });
        this.currentClassDoc = holder;
        return this.output(writer, this.callProviders(provider -> provider.documentClass(holder)));
    }

    private Content aggregateFieldDoc(FieldDoc holder, TagletWriter writer) {
        return this.output(writer, this.callProviders(provider -> provider.documentField(holder)));
    }

    private Content aggregateConstructorDoc(ConstructorDoc holder, TagletWriter writer) {
        return this.output(writer, this.callProviders(provider -> provider.documentConstructor(holder)));
    }

    private Content aggregateMethodDoc(MethodDoc holder, TagletWriter writer) {
        return this.output(writer, this.callProviders(provider -> provider.documentMethod(holder)));
    }

    private Content aggregateAnnotationTypeDoc(AnnotationTypeDoc holder, TagletWriter writer) {
        this.newHolderLifecycle(holder, this.currentAnnotationTypeDoc, new IDocLifecycle<AnnotationTypeDoc>(){

            @Override
            public void beginDoc(AnnotationTypeDoc newDoc, ILivedocProvider<?> provider) {
                provider.beginAnnotationType(newDoc);
            }

            @Override
            public void endDoc(AnnotationTypeDoc oldDoc, ILivedocProvider<?> provider) {
                provider.endAnnotationType(oldDoc);
            }
        });
        this.currentAnnotationTypeDoc = holder;
        return this.output(writer, this.callProviders(provider -> provider.documentAnnotationType(holder)));
    }

    private Content aggregateAnnotationTypeElementDoc(AnnotationTypeElementDoc holder, TagletWriter writer) {
        return this.output(writer, this.callProviders(provider -> provider.documentAnnotationTypeElement(holder)));
    }

    public void tearDown() throws RecommendersTagletException {
        this.providers.forEach(provider -> {
            try {
                provider.endClass(this.currentClassDoc);
                provider.endAnnotationType(this.currentAnnotationTypeDoc);
                provider.endPackage(this.currentPackageDoc);
                provider.tearDown();
            }
            catch (LiveDocProviderException e) {
                LOG.error("Couldn't tear down Provider \"{}\"", (Object)provider.getId(), (Object)e);
            }
        });
    }

    private boolean classOrInterface(Doc holder) {
        return holder.isClass() || holder.isInterface();
    }

    private <T extends Doc> void newHolderLifecycle(T newHolder, T currentHolder, IDocLifecycle<T> lifecycle) {
        if (this.holderChanged(currentHolder, newHolder)) {
            this.providers.forEach(provider -> {
                if (currentHolder != null) {
                    lifecycle.endDoc(currentHolder, (ILivedocProvider<?>)provider);
                }
                lifecycle.beginDoc(newHolder, (ILivedocProvider<?>)provider);
            });
        }
    }

    private boolean holderChanged(Doc currentHolder, Doc newHolder) {
        return !newHolder.equals(currentHolder);
    }

    private Content output(TagletWriter writer, String output) {
        if (output.length() == 0) {
            return null;
        }
        Content content = writer.getOutputInstance();
        RawHtml html = new RawHtml(output);
        content.addContent((Content)html);
        return content;
    }

    private String callProviders(IProviderCall call) {
        StringBuilder sb = new StringBuilder();
        this.providers.forEach(provider -> {
            ProviderOutput output = call.document((ILivedocProvider<?>)provider);
            if (output != null) {
                sb.append(output.getHtmlCode());
            }
        });
        return sb.toString();
    }

    private static interface IDocLifecycle<T extends Doc> {
        public void beginDoc(T var1, ILivedocProvider<?> var2);

        public void endDoc(T var1, ILivedocProvider<?> var2);
    }

    private static interface IProviderCall {
        public ProviderOutput document(ILivedocProvider<?> var1);
    }
}

