/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.sun.tools.javadoc.Main;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.recommenders.internal.livedoc.javadoc.RecommendersDoclet;
import org.eclipse.recommenders.livedoc.ILivedoc;
import org.eclipse.recommenders.livedoc.utils.LivedocChecks;
import org.eclipse.recommenders.livedoc.utils.LivedocPreconditionException;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Livedoc
implements ILivedoc {
    private static final String RECOMMENDERS_DOCLET = "org.eclipse.recommenders.internal.livedoc.javadoc.RecommendersDoclet";
    private boolean verbose;
    private boolean highlight;
    private File sourceDir;
    private File outputDir;
    private List<String> subpackages;
    private String groupId;
    private String artifactId;
    private String version;
    private List<URL> modelRepositories;
    private Map<String, String[]> providerArguments;
    private String encoding;
    private static final Logger LOG = LoggerFactory.getLogger(Livedoc.class);
    private final List<File> additionalClasspathEntries;
    private boolean splitIndex;
    private List<String> doclintOptions;

    public Livedoc(File sourceFiles, File outputDir, List<String> subpackages, String groupId, String artifactId, String version) {
        this.sourceDir = sourceFiles;
        this.outputDir = outputDir;
        this.subpackages = subpackages;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.additionalClasspathEntries = Lists.newLinkedList();
        this.verbose = false;
        this.highlight = false;
    }

    @Override
    public boolean generate() throws LivedocPreconditionException {
        LivedocChecks.preconditions(false);
        RecommendersDoclet doclet = RecommendersDoclet.instance();
        doclet.loadProviders(this.providerArguments);
        doclet.setProjectCoordinate(new ProjectCoordinate(this.groupId, this.artifactId, Versions.canonicalizeVersion((String)this.version)));
        doclet.setHighlight(this.highlight);
        doclet.setModelRepositories(this.modelRepositories);
        List<String> providers = doclet.getProviderIds();
        if (providers.isEmpty()) {
            LOG.warn("No Livedoc Providers are used, generating plain Javadoc. Maybe wrong usage of -p option?");
        }
        if (this.verbose) {
            this.logProviderInfo(providers);
        }
        PrintWriter sysOut = new PrintWriter(System.out);
        PrintWriter sysErr = new PrintWriter(System.err);
        Main.execute((String)"LiveDoc", (PrintWriter)sysErr, (PrintWriter)sysOut, (PrintWriter)sysOut, (String)RECOMMENDERS_DOCLET, (ClassLoader)this.getClass().getClassLoader(), (String[])this.buildArgs());
        return true;
    }

    private void logProviderInfo(List<String> providers) {
        String taglets = Joiner.on((String)", ").join(providers);
        LOG.info("List of used Providers: {}", (Object)(taglets.isEmpty() ? "(empty)" : taglets));
    }

    private String[] buildArgs() {
        ArrayList javadocArgs = Lists.newArrayList();
        if (this.verbose) {
            javadocArgs.add("-verbose");
        } else {
            javadocArgs.add("-quiet");
        }
        javadocArgs.add("-d");
        javadocArgs.add(this.outputDir.getAbsolutePath());
        javadocArgs.add("-doclet");
        javadocArgs.add(RECOMMENDERS_DOCLET);
        if (this.subpackages != null) {
            javadocArgs.add("-subpackages");
            javadocArgs.add(Joiner.on((String)":").join(this.subpackages.iterator()));
        }
        javadocArgs.add("-private");
        if (!this.additionalClasspathEntries.isEmpty()) {
            javadocArgs.add("-classpath");
            javadocArgs.add(Joiner.on((char)File.pathSeparatorChar).join(this.additionalClasspathEntries.iterator()));
        }
        javadocArgs.add("-sourcepath");
        javadocArgs.add(this.sourceDir.getAbsolutePath());
        javadocArgs.add("-docencoding");
        javadocArgs.add("UTF-8");
        javadocArgs.add("-charset");
        javadocArgs.add("UTF-8");
        javadocArgs.add("-encoding");
        if (this.encoding != null) {
            javadocArgs.add(this.encoding);
        } else {
            javadocArgs.add(this.guessEncoding());
        }
        if (this.splitIndex) {
            javadocArgs.add("-splitIndex");
        }
        javadocArgs.add("-Xdoclint:".concat(Joiner.on((String)",").join(this.doclintOptions)));
        return javadocArgs.toArray(new String[0]);
    }

    private String guessEncoding() {
        String defaultEncoding = Charset.defaultCharset().name();
        BufferedInputStream bis = null;
        try {
            CharsetDetector detector = new CharsetDetector();
            Collection sourceFiles = FileUtils.listFiles((File)this.sourceDir, (String[])new String[]{"java"}, (boolean)true);
            Iterable suppliers = Iterables.transform((Iterable)sourceFiles, (Function)new Function<File, InputSupplier<FileInputStream>>(){

                public InputSupplier<FileInputStream> apply(File file) {
                    return Files.newInputStreamSupplier((File)file);
                }
            });
            bis = new BufferedInputStream((InputStream)ByteStreams.join((Iterable)suppliers).getInput());
            detector.setDeclaredEncoding(defaultEncoding);
            detector.setText((InputStream)bis);
            CharsetMatch match = detector.detect();
            LOG.info("Using guessed encoding {} with {}% confidence.", (Object)match.getName(), (Object)match.getConfidence());
            String string = match.getName();
            IOUtils.closeQuietly((InputStream)bis);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.warn("Encoding couldn't be guessed, using system default encoding {}.", (Object)defaultEncoding, (Object)e);
            String string = defaultEncoding;
            return string;
        }
        finally {
            IOUtils.closeQuietly(bis);
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public void setSubpackages(List<String> subpackages) {
        this.subpackages = subpackages;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public void setArtifactVersion(String version) {
        this.version = version;
    }

    @Override
    public void setModelRepositories(List<URL> modelRepositories) {
        this.modelRepositories = modelRepositories;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    @Override
    public void setProviderArguments(Map<String, String[]> providerArguments) {
        this.providerArguments = providerArguments;
    }

    @Override
    public void addAdditonalClasspathEntry(File entry) {
        this.additionalClasspathEntries.add(entry);
    }

    @Override
    public void setSplitIndex(boolean splitIndex) {
        this.splitIndex = splitIndex;
    }

    @Override
    public void setDoclintOptions(List<String> doclintOptions) {
        this.doclintOptions = doclintOptions;
    }
}

