/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers;

import com.google.common.base.Optional;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.recommenders.livedoc.providers.ILivedocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLiveDocProvider<C extends ProviderConfiguration>
implements ILivedocProvider<C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLiveDocProvider.class);
    private ProjectCoordinate pc;
    private IModelRepository modelRepo;
    private IModelIndex modelIndex;
    private C configuration = this.getConfiguration();
    private String[] providerArguments;

    @Override
    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        this.pc = pc;
        this.modelRepo = repo;
        this.modelIndex = index;
        this.parseProviderArguments(ArrayUtils.nullToEmpty((String[])this.providerArguments));
    }

    private void parseProviderArguments(String[] providerArguments) throws LiveDocProviderException {
        CmdLineParser parser = new CmdLineParser(this.getConfiguration());
        try {
            parser.parseArgument(providerArguments);
        }
        catch (CmdLineException e) {
            throw new LiveDocProviderException(e);
        }
    }

    @Override
    public C getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.newProviderConfiguration();
        }
        return this.configuration;
    }

    @Override
    public ProviderOutput documentOverview(RootDoc holder) {
        return null;
    }

    @Override
    public void beginPackage(PackageDoc newPackageDoc) {
    }

    @Override
    public ProviderOutput documentPackage(PackageDoc holder) {
        return null;
    }

    @Override
    public void beginClass(ClassDoc newClassDoc) {
    }

    @Override
    public ProviderOutput documentClass(ClassDoc holder) {
        return null;
    }

    @Override
    public ProviderOutput documentField(FieldDoc holder) {
        return null;
    }

    @Override
    public ProviderOutput documentConstructor(ConstructorDoc holder) {
        return null;
    }

    @Override
    public ProviderOutput documentMethod(MethodDoc holder) {
        return null;
    }

    @Override
    public void endClass(ClassDoc oldClassDoc) {
    }

    @Override
    public void beginAnnotationType(AnnotationTypeDoc newAnnotationType) {
    }

    @Override
    public ProviderOutput documentAnnotationType(AnnotationTypeDoc holder) {
        return null;
    }

    @Override
    public ProviderOutput documentAnnotationTypeElement(AnnotationTypeElementDoc holder) {
        return null;
    }

    @Override
    public void endAnnotationType(AnnotationTypeDoc oldAnnotationTypeDoc) {
    }

    @Override
    public void endPackage(PackageDoc oldPackageDoc) {
    }

    @Override
    public void tearDown() throws LiveDocProviderException {
    }

    protected Optional<File> fetchModelArchive(String classifier) {
        Optional modelArchive = Optional.absent();
        Optional coordinate = this.modelIndex.suggest(this.pc, classifier);
        if (!coordinate.isPresent()) {
            return Optional.absent();
        }
        modelArchive = this.modelRepo.resolve((ModelCoordinate)coordinate.get(), false);
        if (!modelArchive.isPresent()) {
            LOG.error("Couldn't find model for indexed coordinate. The index of model repository \"{}\" is outdated.", (Object)this.modelRepo);
        }
        return modelArchive;
    }

    protected StringBuilder highlight(StringBuilder sb) {
        if (((ProviderConfiguration)this.configuration).isHighlight()) {
            sb.insert(0, "<div style=\"background-color:#FFFFD5;\">");
            sb.append("</div>");
        }
        return sb;
    }

    protected String highlight(String string) {
        if (((ProviderConfiguration)this.configuration).isHighlight()) {
            return "<div style=\"background-color:#FFFFD5;\">" + string + "</div>";
        }
        return string;
    }

    @Override
    public int getRanking() {
        return Integer.MAX_VALUE;
    }

    public String[] getArguments() {
        return this.providerArguments;
    }

    @Override
    public void setArguments(String[] args) {
        this.providerArguments = args;
    }

    public ProjectCoordinate getProjectCoordinate() {
        return this.pc;
    }

    public IModelRepository getRepo() {
        return this.modelRepo;
    }

    public IModelIndex getIndex() {
        return this.modelIndex;
    }

    @Override
    public int compareTo(ILivedocProvider<?> o) {
        return Integer.valueOf(this.getRanking()).compareTo(o.getRanking());
    }
}

