/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.utils;

import com.sun.javadoc.MethodDoc;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.utils.names.IMethodName;

public class ItemBuilder {
    private static final String SPACE = " ";
    private MethodDoc holder;
    private StringBuilder sb = new StringBuilder();

    public ItemBuilder(MethodDoc holder) {
        this.holder = holder;
    }

    public static ItemBuilder create(MethodDoc holder) {
        return new ItemBuilder(holder);
    }

    public ItemBuilder method(IMethodName methodName) {
        this.sb.append("<code>").append((CharSequence)LiveDocUtils.strong(LiveDocUtils.htmlLink(this.holder.containingClass(), methodName))).append(LiveDocUtils.listParameterTypes(methodName)).append("</code>").append(SPACE);
        return this;
    }

    public ItemBuilder string(String string) {
        this.sb.append(string).append(SPACE);
        return this;
    }

    public ItemBuilder withPercentage(double percentage) {
        this.sb.append(String.format("(<font color=\"#0000FF\">%1$.0f%%</font>)", percentage)).append(SPACE);
        return this;
    }

    public ItemBuilder withTimesAndPercentage(double percentage, int times) {
        this.sb.append(String.format("(<font color=\"#0000FF\">%1$.0f%% - %2$d times</font>)", percentage, times)).append(SPACE);
        return this;
    }

    public String build() {
        return this.sb.toString();
    }
}

