/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class LiveDocUtils {
    public static final String BR = "<br>";
    public static final String CODE = "<code>";
    public static final String CODE_END = "</code>";
    public static final String DD = "<dd>";
    public static final String DD_END = "</dd>";
    public static final String DT = "<dt>";
    public static final String DT_END = "</dt>";
    public static final String LI = "<li>";
    public static final String LI_END = "</li>";
    public static final String STRONG_END = "</strong>";
    public static final String STRONG = "<strong>";
    public static final String UL = "<ul>";
    public static final String UL_END = "</ul>";
    private static Map<Pair<ClassDoc, IMethodName>, ClassDoc> methodHolderCache = Maps.newHashMapWithExpectedSize((int)6000);
    private static Comparator<Recommendation<IMethodName>> C_BY_RELEVANCE_THEN_NAME = new Comparator<Recommendation<IMethodName>>(){

        @Override
        public int compare(Recommendation<IMethodName> o1, Recommendation<IMethodName> o2) {
            return ComparisonChain.start().compare(Recommendations.asPercentage(o1), Recommendations.asPercentage(o2)).compare((Comparable)((Object)((IMethodName)o2.getProposal()).getName()), (Comparable)((Object)((IMethodName)o1.getProposal()).getName())).result();
        }
    };

    public static <R extends Recommendation<IMethodName>> List<R> topMethods(Iterable<R> recommendations, int numberOfTopElements, double minRelevance) {
        return Ordering.from(C_BY_RELEVANCE_THEN_NAME).greatestOf(Recommendations.filterRelevance(recommendations, (double)minRelevance), numberOfTopElements);
    }

    public static String htmlMethodSignature(IMethodName method) {
        StringBuilder sb = new StringBuilder();
        sb.append(CODE);
        sb.append(LiveDocUtils.simpleMethodName(method));
        sb.append("(");
        int i = 0;
        while (i < method.getParameterTypes().length) {
            ITypeName parameter = method.getParameterTypes()[i];
            sb.append(Names.vm2srcQualifiedType((ITypeName)parameter));
            if (i < method.getParameterTypes().length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        sb.append(CODE_END);
        return sb.toString();
    }

    private static String simpleMethodName(IMethodName method) {
        return method.isInit() ? Names.vm2srcSimpleTypeName((ITypeName)method.getDeclaringType()) : method.getName();
    }

    @Deprecated
    public static IMethodName asIMethodName(MethodDoc methodDoc) {
        String srcDeclaringType = StringUtils.substringBeforeLast((String)methodDoc.qualifiedName(), (String)".");
        String methodName = StringUtils.substringAfterLast((String)methodDoc.qualifiedName(), (String)".");
        String[] parameters = LiveDocUtils.asStringArray(methodDoc.parameters());
        return VmMethodName.get((String)Names.src2vmMethod((String)srcDeclaringType, (String)methodName, (String[])parameters, (String)methodDoc.returnType().qualifiedTypeName()));
    }

    public static String[] asStringArray(Parameter[] parameters) {
        String[] result = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            result[i] = parameter.type().qualifiedTypeName();
            ++i;
        }
        return result;
    }

    public static ITypeName extractTypeName(Doc holder) {
        if (holder.isMethod()) {
            String typeName = StringUtils.substringBefore((String)holder.toString(), (String)"(");
            typeName = StringUtils.substringBeforeLast((String)typeName, (String)".");
            return VmTypeName.get((String)Names.src2vmType((String)typeName));
        }
        return VmTypeName.get((String)Names.src2vmType((String)holder.toString()));
    }

    public static URI relativeUri(ITypeName type) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(LiveDocUtils.climbUp(type.getPackage())).append(type.getPackage().getIdentifier()).append("/").append(type.getClassName()).append(".html");
        return new URI(sb.toString());
    }

    public static URI relativeUri(ClassDoc classDoc) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(LiveDocUtils.climbUp(classDoc.containingPackage())).append(StringUtils.replace((String)classDoc.containingPackage().name(), (String)".", (String)"/")).append("/").append(classDoc.name()).append(".html");
        return new URI(sb.toString());
    }

    public static URI relativeUri(IMethodName method) throws URISyntaxException {
        StringBuilder fragment = new StringBuilder(LiveDocUtils.simpleMethodName(method));
        fragment.append(LiveDocUtils.listParameterTypes(method));
        return new URI(null, LiveDocUtils.relativeUri(method.getDeclaringType()).toString(), fragment.toString());
    }

    private static String climbUp(IPackageName packageName) {
        int length = StringUtils.countMatches((CharSequence)packageName.getIdentifier(), (CharSequence)"/");
        String result = "";
        int i = 0;
        while (i <= length) {
            result = String.valueOf(result) + "../";
            ++i;
        }
        return result;
    }

    private static String climbUp(PackageDoc packageDoc) {
        int length = StringUtils.countMatches((CharSequence)packageDoc.name(), (CharSequence)".");
        String result = "";
        int i = 0;
        while (i <= length) {
            result = String.valueOf(result) + "../";
            ++i;
        }
        return result;
    }

    public static StringBuilder htmlLink(IMethodName method) {
        StringBuilder sb = new StringBuilder("<a href=");
        sb.append("\"");
        try {
            sb.append(LiveDocUtils.relativeUri(method).toString());
        }
        catch (URISyntaxException e) {
            System.err.println("Couldn't create HTML Link for:" + method.getIdentifier());
            e.printStackTrace();
        }
        sb.append("\">").append(LiveDocUtils.simpleMethodName(method));
        sb.append("</a>");
        return sb;
    }

    @Beta
    public static StringBuilder htmlLink(ClassDoc callee, IMethodName methodName) {
        Pair pair = Pair.newPair((Object)callee, (Object)methodName);
        if (methodHolderCache.containsKey(pair)) {
            ITypeName typeName = LiveDocUtils.extractTypeName((Doc)methodHolderCache.get(pair));
            return LiveDocUtils.htmlLink(typeName, methodName);
        }
        Optional<ClassDoc> holder = LiveDocUtils.searchMethodHolder(callee, methodName);
        if (holder.isPresent()) {
            ClassDoc declaringClass = (ClassDoc)holder.get();
            methodHolderCache.put((Pair<ClassDoc, IMethodName>)pair, declaringClass);
            ITypeName typeName = LiveDocUtils.extractTypeName((Doc)declaringClass);
            return LiveDocUtils.htmlLink(typeName, methodName);
        }
        return new StringBuilder(methodName.getName());
    }

    private static Optional<ClassDoc> searchMethodHolder(ClassDoc callee, IMethodName methodName) {
        if (callee == null) {
            return Optional.absent();
        }
        if (LiveDocUtils.methodInClassDoc(callee, methodName)) {
            return Optional.of((Object)callee);
        }
        Optional<ClassDoc> result = LiveDocUtils.searchMethodHolder(callee.superclass(), methodName);
        if (result.isPresent() && !((ClassDoc)result.get()).isInterface()) {
            return result;
        }
        return LiveDocUtils.searchInterfaces(callee, methodName).or(result);
    }

    private static Optional<ClassDoc> searchInterfaces(ClassDoc callee, IMethodName methodName) {
        ClassDoc interfaze;
        ClassDoc[] classDocArray = callee.interfaces();
        int n = classDocArray.length;
        int n2 = 0;
        while (n2 < n) {
            interfaze = classDocArray[n2];
            if (LiveDocUtils.methodInClassDoc(interfaze, methodName)) {
                return Optional.of((Object)interfaze);
            }
            ++n2;
        }
        ClassDoc[] classDocArray2 = callee.interfaces();
        if (classDocArray2.length != 0) {
            interfaze = classDocArray2[0];
            return LiveDocUtils.searchInterfaces(interfaze, methodName);
        }
        return Optional.absent();
    }

    private static boolean methodInClassDoc(ClassDoc callee, IMethodName methodName) {
        MethodDoc[] methods;
        MethodDoc[] methodDocArray = methods = callee.methods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDoc method = methodDocArray[n2];
            if (LiveDocUtils.returnTypeEquals(methodName, method) && LiveDocUtils.simpleNameEquals(methodName, method) && LiveDocUtils.parameterTypesEquals(methodName, method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static StringBuilder htmlLink(ITypeName declaringClass, IMethodName methodName) {
        methodName = VmMethodName.get((String)declaringClass.getIdentifier(), (String)methodName.getSignature());
        return LiveDocUtils.htmlLink(methodName);
    }

    public static StringBuilder htmlLink(ClassDoc classDoc) {
        StringBuilder sb = new StringBuilder("<a href=");
        sb.append("\"");
        try {
            sb.append(LiveDocUtils.relativeUri(classDoc).toString());
        }
        catch (URISyntaxException e) {
            System.err.println("Couldn't create HTML Link for:" + classDoc.qualifiedName());
            e.printStackTrace();
        }
        sb.append("\"");
        sb.append(" title=\"class in ").append(classDoc.containingPackage().name()).append("\">").append(classDoc.name()).append("</a>");
        return sb;
    }

    public static StringBuilder htmlLink(ITypeName type) {
        StringBuilder sb = new StringBuilder("<a href=");
        sb.append("\"");
        try {
            sb.append(LiveDocUtils.relativeUri(type).toString());
        }
        catch (URISyntaxException e) {
            System.err.println("Couldn't create HTML Link for:" + type.getIdentifier());
            e.printStackTrace();
        }
        sb.append("\"");
        sb.append(" title=\"class in ").append(StringUtils.replace((String)type.getPackage().getIdentifier(), (String)"/", (String)".")).append("\">").append(type.getClassName()).append("</a>");
        return sb;
    }

    public static boolean methodSignatureEquals(IMethodName methodName, MethodDoc methodDoc) {
        if (!LiveDocUtils.qualifiedNameEquals(methodName, methodDoc)) {
            return false;
        }
        if (!LiveDocUtils.parameterTypesEquals(methodName, methodDoc)) {
            return false;
        }
        return LiveDocUtils.returnTypeEquals(methodName, methodDoc);
    }

    private static boolean returnTypeEquals(IMethodName methodName, MethodDoc methodDoc) {
        return LiveDocUtils.typeEquals(methodName.getReturnType(), methodDoc.returnType());
    }

    private static boolean parameterTypesEquals(IMethodName methodName, MethodDoc methodDoc) {
        Parameter[] methodDocParameters;
        ITypeName[] methodNameParameters = methodName.getParameterTypes();
        if (methodNameParameters.length == (methodDocParameters = methodDoc.parameters()).length) {
            int i = 0;
            while (i < methodNameParameters.length) {
                if (!LiveDocUtils.typeEquals(methodNameParameters[i], methodDocParameters[i].type())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean typeEquals(ITypeName typeName, Type type) {
        Type[] bounds;
        if (Names.vm2srcQualifiedType((ITypeName)typeName).equals(LiveDocUtils.removeGenerics(type))) {
            return true;
        }
        if (type.asTypeVariable() != null && (bounds = type.asTypeVariable().bounds()).length == 0) {
            if (typeName.isArrayType()) {
                boolean dimensionsEqual;
                boolean bl = dimensionsEqual = StringUtils.countMatches((CharSequence)type.dimension(), (CharSequence)"[]") == typeName.getArrayDimensions();
                return dimensionsEqual && typeName.getArrayBaseType().equals(VmTypeName.OBJECT);
            }
            return typeName.equals(VmTypeName.OBJECT);
        }
        return false;
    }

    private static String removeGenerics(Type type) {
        String generics = StringUtils.defaultString((String)StringUtils.substringBetween((String)type.toString(), (String)"<", (String)">"));
        String toRemove = "<".concat(generics).concat(">");
        return StringUtils.remove((String)type.toString(), (String)toRemove);
    }

    private static boolean qualifiedNameEquals(IMethodName methodName, MethodDoc methodDoc) {
        if (!LiveDocUtils.declaringTypeMatches(methodName, methodDoc)) {
            return false;
        }
        return LiveDocUtils.simpleNameEquals(methodName, methodDoc);
    }

    private static boolean declaringTypeMatches(IMethodName methodName, MethodDoc methodDoc) {
        return LiveDocUtils.typeEquals(methodName.getDeclaringType(), (Type)methodDoc.containingClass());
    }

    private static boolean simpleNameEquals(IMethodName methodName, MethodDoc methodDoc) {
        return methodName.getName().equals(methodDoc.name());
    }

    public static String listParameterTypes(IMethodName method) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        ITypeName[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            sb.append(Names.vm2srcQualifiedType((ITypeName)parameterTypes[i]));
            if (i < parameterTypes.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static StringBuilder strong(StringBuilder textToStrong) {
        textToStrong.insert(0, STRONG);
        textToStrong.append(STRONG_END);
        return textToStrong;
    }

    public static String strong(String textToStrong) {
        return LiveDocUtils.strong(new StringBuilder(textToStrong)).toString();
    }

    public static StringBuilder size(String size, StringBuilder textToSize) {
        textToSize.insert(0, "<span style=\"font-size:" + size + "\">").append("</span>");
        return textToSize;
    }

    public static String size(String size, String textToSize) {
        return LiveDocUtils.size(size, new StringBuilder(textToSize)).toString();
    }

    public static StringBuilder code(StringBuilder textToCode) {
        textToCode.insert(0, CODE).append(CODE_END);
        return textToCode;
    }

    public static String code(String textToCode) {
        return LiveDocUtils.code(new StringBuilder(textToCode)).toString();
    }

    public static String surroundWith(String begin, String text, String end) {
        return begin + text + end;
    }

    public static String color(String color, String text) {
        return LiveDocUtils.surroundWith(LiveDocUtils.surroundWith("<font color=\"", color, "\">"), text, "</font>");
    }

    public static String highlight(String string) {
        return LiveDocUtils.color("#0000FF", string);
    }
}

