/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.utils;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.recommenders.livedoc.utils.LivedocPreconditionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivedocChecks {
    private static final String ENV_JAVA_HOME = System.getenv("JAVA_HOME");
    private static final Logger LOG = LoggerFactory.getLogger(LivedocChecks.class);

    public static void preconditions(boolean printToConsole) throws LivedocPreconditionException {
        LivedocChecks.checkJavaVersion(printToConsole);
        LivedocChecks.checkToolsJar(printToConsole);
    }

    private static void checkJavaVersion(boolean printToConsole) throws LivedocPreconditionException {
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
            LivedocPreconditionException e = new LivedocPreconditionException("Wrong Java Version");
            String error = "Livedoc is only compatible with Java 1.8";
            LOG.error(error, (Throwable)e);
            if (printToConsole) {
                System.err.println(e.getMessage());
                System.err.println(error);
            }
            throw e;
        }
    }

    private static void checkToolsJar(boolean printToConsole) throws LivedocPreconditionException {
        try {
            Class.forName("com.sun.tools.doclets.internal.toolkit.Content");
            File release = new File(SystemUtils.JAVA_HOME, "../release");
            File toolsJar = new File(SystemUtils.JAVA_HOME, "../lib/tools.jar");
            if (toolsJar.isFile() && LivedocChecks.correctJavaVersionInReleaseFile(release)) {
                return;
            }
            release = new File(ENV_JAVA_HOME, "release");
            toolsJar = new File(ENV_JAVA_HOME, "lib/tools.jar");
            if (toolsJar.isFile() && LivedocChecks.correctJavaVersionInReleaseFile(release)) {
                return;
            }
            throw new Exception();
        }
        catch (Exception e) {
            String error = String.format("Livedoc could not find a correct JDK8 tools.jar, neither in \"%s\" (java.home) nor in \"%s\" ($JAVA_HOME)", SystemUtils.JAVA_HOME, ENV_JAVA_HOME);
            LOG.error(error, (Throwable)e);
            if (printToConsole) {
                System.err.println(error);
            }
            throw new LivedocPreconditionException(e);
        }
    }

    private static boolean correctJavaVersionInReleaseFile(File release) throws IOException {
        Pattern regexp = Pattern.compile("JAVA\\_VERSION=\"1\\.8\\..*");
        Matcher matcher = regexp.matcher("");
        BufferedReader reader = Files.newReader((File)release, (Charset)StandardCharsets.UTF_8);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String line = null;
        while ((line = lineReader.readLine()) != null) {
            matcher.reset(line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

