/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.recommenders.utils.Version;

public final class Versions {
    private static final Pattern VERSION_PATTERNS = Pattern.compile("(([1-9][0-9]*)|[0-9])(\\.(([1-9][0-9]*)|[0-9])){2}");
    private static final Pattern FIND_VERSION_PATTERN = Pattern.compile("(([1-9][0-9]*)|[0-9])(\\.(([1-9][0-9]*)|[0-9])){0,2}");

    private Versions() {
    }

    public static Version findClosest(Version startingPoint, Collection<Version> candidates) {
        Collection<Version> closestCandidates = Versions.closestCandidates(candidates, new MajorDistance(startingPoint));
        closestCandidates = Versions.closestCandidates(closestCandidates, new MinorDistance(startingPoint));
        closestCandidates = Versions.closestCandidates(closestCandidates, new PatchDistance(startingPoint));
        return (Version)Iterables.getOnlyElement(closestCandidates);
    }

    private static Collection<Version> closestCandidates(Collection<Version> candidates, Function<Version, Integer> metric) {
        LinkedList closestCandidatesByMajorVersion = Lists.newLinkedList();
        int closestDistance = Integer.MAX_VALUE;
        for (Version candidate : candidates) {
            int distance = (Integer)metric.apply((Object)candidate);
            if (distance < closestDistance) {
                closestDistance = distance;
                closestCandidatesByMajorVersion.clear();
                closestCandidatesByMajorVersion.add(candidate);
                continue;
            }
            if (distance != closestDistance) continue;
            closestCandidatesByMajorVersion.add(candidate);
        }
        return closestCandidatesByMajorVersion;
    }

    public static boolean isValidVersion(String version) {
        return VERSION_PATTERNS.matcher(version).matches();
    }

    public static String canonicalizeVersion(String version) {
        Matcher matcher = FIND_VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            String temp = version.substring(matcher.start(), matcher.end());
            return Versions.addMissingVersionPartsIfNecessary(temp);
        }
        return version;
    }

    private static String addMissingVersionPartsIfNecessary(String version) {
        String temp = version;
        String[] parts = version.split("\\.");
        int missingVersionParts = 3 - parts.length;
        int i = 0;
        while (i < missingVersionParts) {
            temp = String.valueOf(temp) + ".0";
            ++i;
        }
        return temp;
    }

    private static class MajorDistance
    implements Function<Version, Integer> {
        private final Version referencePoint;

        public MajorDistance(Version referencePoint) {
            this.referencePoint = referencePoint;
        }

        public Integer apply(Version version) {
            if (version.compareTo(this.referencePoint) >= 0) {
                return 2 * (version.getMajor() - this.referencePoint.getMajor()) + 1;
            }
            return 2 * (this.referencePoint.getMajor() - version.getMajor());
        }
    }

    private static class MinorDistance
    implements Function<Version, Integer> {
        private final Version referencePoint;

        public MinorDistance(Version referencePoint) {
            this.referencePoint = referencePoint;
        }

        public Integer apply(Version version) {
            if (version.compareTo(this.referencePoint) >= 0) {
                return 2 * (version.getMinor() - this.referencePoint.getMinor()) + 1;
            }
            return 2 * (this.referencePoint.getMinor() - version.getMinor());
        }
    }

    private static class PatchDistance
    implements Function<Version, Integer> {
        private final Version referencePoint;

        public PatchDistance(Version referencePoint) {
            this.referencePoint = referencePoint;
        }

        public Integer apply(Version version) {
            if (version.compareTo(this.referencePoint) >= 0) {
                return 2 * (version.getPatch() - this.referencePoint.getPatch()) + 1;
            }
            return 2 * (this.referencePoint.getPatch() - version.getPatch());
        }
    }
}

