/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import static org.eclipse.recommenders.utils.Checks.cast;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;

import com.google.common.collect.Multiset;
import com.google.common.collect.Multiset.Entry;

public class CompletionTypesChart extends AbstractChartPage {

    private final IDataPersistenceService persistenceService;

    @Inject
    public CompletionTypesChart(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public final Chart createChart() {
        List<String> completionNamesList = new ArrayList<String>();
        List<Double> completionCountsList = new ArrayList<Double>();
        Multiset<Object> proposalKindBag = StatisticData.create(persistenceService).getStatsData();
        List<Entry<Object>> topUsingCount = Bags.topUsingCount(proposalKindBag, 30);

        if (getParent() != null) {
            new Label(getParent(), SWT.NONE)
                    .setText("Total number of triggered completion types: " + getTotalNumber(topUsingCount));
        }

        for (Entry<Object> entry : topUsingCount) {
            Entry<Object> element = cast(entry);
            String name = element.getElement().toString().toLowerCase().replace('_', ' ');
            completionNamesList.add(name);
            completionCountsList.add((double) element.getCount());
        }

        String[] names = completionNamesList.toArray(new String[completionNamesList.size()]);
        Double[] values = completionCountsList.toArray(new Double[completionCountsList.size()]);

        return PieChartFactory.create("Completion Types", names, values);
    }

    private int getTotalNumber(List<Entry<Object>> topUsingCount) {
        int result = 0;
        for (Entry<Object> entry : topUsingCount) {
            result += entry.getCount();
        }
        return result;
    }
}
