/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

import com.google.common.base.Preconditions;

public final class PieChartFactory {

    public static Chart create(String title, String[] namesForSeries, Double[] valuesForSeries) {

        Preconditions.checkNotNull(title);
        Preconditions.checkNotNull(namesForSeries);
        Preconditions.checkNotNull(valuesForSeries);
        Preconditions.checkArgument(namesForSeries.length == valuesForSeries.length, "check array length");

        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        chart.getBlock().setBackground(ColorDefinitionImpl.WHITE());
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        chart.setSeriesThickness(5);
        chart.getLegend().getOutline().setVisible(false);
        chart.getTitle().getLabel().getCaption().setValue(title);

        if (namesForSeries.length == 0 || valuesForSeries.length == 0) {
            chart.getTitle().getLabel().getCaption().setValue("No Data Available Yet");
        }

        TextDataSet categoryValues = TextDataSetImpl.create(namesForSeries);
        NumberDataSet seriesOneValues = NumberDataSetImpl.create(valuesForSeries);

        SampleData data = DataFactory.eINSTANCE.createSampleData();
        BaseSampleData sampleData = DataFactory.eINSTANCE.createBaseSampleData();
        sampleData.setDataSetRepresentation(""); //$NON-NLS-1$
        data.getBaseSampleData().add(sampleData);

        OrthogonalSampleData orthogonal = DataFactory.eINSTANCE.createOrthogonalSampleData();
        orthogonal.setDataSetRepresentation(""); //$NON-NLS-1$
        orthogonal.setSeriesDefinitionIndex(0);
        data.getOrthogonalSampleData().add(orthogonal);
        chart.setSampleData(data);

        Series category = SeriesImpl.create();
        category.setDataSet(categoryValues);

        SeriesDefinition seriesDef = SeriesDefinitionImpl.create();
        chart.getSeriesDefinitions().add(seriesDef);
        seriesDef.getSeriesPalette().shift(0);
        seriesDef.getSeries().add(category);

        PieSeries pieSeries = (PieSeries) PieSeriesImpl.create();
        pieSeries.setDataSet(seriesOneValues);
        pieSeries.setExplosion(5);

        SeriesDefinition series = SeriesDefinitionImpl.create();
        seriesDef.getSeriesDefinitions().add(series);
        series.getSeries().add(pieSeries);

        return chart;
    }

    private PieChartFactory() {
    }
}
