/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.renderer;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChartPage implements PaintListener, IPageContent {

    private static final Logger LOG = LoggerFactory.getLogger(AbstractChartPage.class);
    private IDeviceRenderer renderer;
    private Chart chart;
    private Composite parent;

    public AbstractChartPage() {
        final PluginSettings setting = PluginSettings.instance();
        try {
            renderer = setting.getDevice("dv.SWT");
        } catch (Exception e) {
            LOG.debug(e.getMessage());
        }
    }

    @Override
    public Composite createContent(Composite detailParent) {
        parent = createWrapperComposite(detailParent);
        chart = createChart();
        GridData gridData = new GridData(GridData.FILL_BOTH);
        Canvas canvas = new Canvas(parent, SWT.BORDER);
        canvas.setLayoutData(gridData);
        canvas.addPaintListener(this);
        new Label(parent, SWT.NONE);
        return parent;
    }

    @Override
    public void paintControl(PaintEvent paintEvent) {
        renderer.setProperty(IDeviceRenderer.GRAPHICS_CONTEXT, paintEvent.gc);
        Composite composite = (Composite) paintEvent.getSource();
        Rectangle rectangle = composite.getClientArea();
        Bounds bounds = BoundsImpl.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        bounds.scale(72d / renderer.getDisplayServer().getDpiResolution());
        Generator generator = Generator.instance();
        try {
            generator.render(renderer, generator.build(renderer.getDisplayServer(), chart, bounds, null));
        } catch (Exception e) {
            LOG.debug(e.getMessage());
        }
    }

    private Composite createWrapperComposite(Composite parent) {
        Composite newComp = new Composite(parent, SWT.NONE);
        newComp.setLayout(new GridLayout());
        newComp.setLayoutData(new GridData(GridData.FILL_BOTH));
        new Label(newComp, SWT.NONE);
        return newComp;
    }

    /**
     * Composite parent of this UI page.
     */
    protected Composite getParent() {
        return parent;
    }

    /**
     * Set chart here to redraw the UI page.
     */
    protected void setChart(Chart chart) {
        this.chart = chart;
    }

    public abstract Chart createChart();
}
