/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.common.base.Preconditions;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;

public class BarChartFactory {
    public static Chart create(String title, String barTitle, String[] namesForSeries, Double[] valuesForSeries) {
        Preconditions.checkNotNull((Object)title);
        Preconditions.checkNotNull((Object)namesForSeries);
        Preconditions.checkNotNull((Object)valuesForSeries);
        Preconditions.checkArgument((namesForSeries.length == valuesForSeries.length ? 1 : 0) != 0, (Object)"check array length");
        ChartWithAxes barChart = ChartWithAxesImpl.create();
        barChart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        barChart.getBlock().getOutline().setVisible(false);
        Plot plot = barChart.getPlot();
        plot.getOutline().setVisible(false);
        barChart.getTitle().getLabel().getCaption().setValue(title);
        if (namesForSeries.length == 0 || valuesForSeries.length == 0) {
            barChart.getTitle().getLabel().getCaption().setValue("No Data Available Yet");
        }
        Axis xAxis = barChart.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.TEXT_LITERAL);
        xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        Axis yAxis = barChart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxis.setType(AxisType.LINEAR_LITERAL);
        yAxis.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        sampleData.getBaseSampleData().add((Object)DataFactory.eINSTANCE.createBaseSampleData());
        sampleData.getOrthogonalSampleData().add((Object)DataFactory.eINSTANCE.createOrthogonalSampleData());
        barChart.setSampleData(sampleData);
        Series category = SeriesImpl.create();
        category.setDataSet((DataSet)TextDataSetImpl.create((Object)namesForSeries));
        SeriesDefinition seriesX = SeriesDefinitionImpl.create();
        xAxis.getSeriesDefinitions().add((Object)seriesX);
        seriesX.getSeries().add((Object)category);
        BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
        barSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)valuesForSeries));
        barSeries.setSeriesIdentifier((Object)barTitle);
        barSeries.getLabel().setVisible(true);
        barSeries.setLabelPosition(Position.INSIDE_LITERAL);
        SeriesDefinition seriesY = SeriesDefinitionImpl.create();
        seriesY.getSeriesPalette().shift(-1);
        yAxis.getSeriesDefinitions().add((Object)seriesY);
        seriesY.getSeries().add((Object)barSeries);
        return barChart;
    }
}

