/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.inject.Inject;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.charts.PieChartFactory;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.swt.widgets.Label;

public class CodeCompletionChart
extends AbstractChartPage {
    private final IDataPersistenceService service;

    @Inject
    public CodeCompletionChart(IDataPersistenceService service) {
        this.service = service;
    }

    @Override
    public final Chart createChart() {
        String title = "Triggered Code Completion";
        StatisticData statsData = StatisticData.create((IDataPersistenceService)this.service);
        double concludedCompletions = statsData.getOkayEvents().size();
        double abortedCompletions = statsData.getAbortedEvents().size();
        String[] names = new String[]{"Concluded Completions", "Aborted Completions"};
        Double[] values = new Double[]{concludedCompletions, abortedCompletions};
        if (this.getParent() != null) {
            new Label(this.getParent(), 0).setText("Total number of triggered code completion engine: " + this.getTotalNumber(statsData));
        }
        if (this.isNoDataAvailable(concludedCompletions, abortedCompletions)) {
            return PieChartFactory.create(title, new String[0], new Double[0]);
        }
        return PieChartFactory.create(title, names, values);
    }

    private int getTotalNumber(StatisticData statsData) {
        int result = 0;
        result += statsData.getOkayEvents().size();
        return result += statsData.getAbortedEvents().size();
    }

    private boolean isNoDataAvailable(double concludedCompletions, double abortedCompletions) {
        return concludedCompletions == 0.0 && abortedCompletions == 0.0;
    }
}

