/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.charts.PieChartFactory;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Label;

public class CompletionTypesChart
extends AbstractChartPage {
    private final IDataPersistenceService persistenceService;

    @Inject
    public CompletionTypesChart(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public final Chart createChart() {
        ArrayList<String> completionNamesList = new ArrayList<String>();
        ArrayList<Double> completionCountsList = new ArrayList<Double>();
        Multiset proposalKindBag = StatisticData.create((IDataPersistenceService)this.persistenceService).getStatsData();
        List topUsingCount = Bags.topUsingCount((Multiset)proposalKindBag, (int)30);
        if (this.getParent() != null) {
            new Label(this.getParent(), 0).setText("Total number of triggered completion types: " + this.getTotalNumber(topUsingCount));
        }
        for (Multiset.Entry entry : topUsingCount) {
            Multiset.Entry element = (Multiset.Entry)Checks.cast((Object)entry);
            String name = element.getElement().toString().toLowerCase().replace('_', ' ');
            completionNamesList.add(name);
            completionCountsList.add(Double.valueOf(element.getCount()));
        }
        String[] names = completionNamesList.toArray(new String[completionNamesList.size()]);
        Double[] values = completionCountsList.toArray(new Double[completionCountsList.size()]);
        return PieChartFactory.create("Completion Types", names, values);
    }

    private int getTotalNumber(List<Multiset.Entry<Object>> topUsingCount) {
        int result = 0;
        for (Multiset.Entry<Object> entry : topUsingCount) {
            result += entry.getCount();
        }
        return result;
    }
}

