/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.charts.BarChartFactory;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.WeekDays;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkbenchData;
import org.eclipse.swt.widgets.Label;

public class EclipseActivityChart
extends AbstractChartPage {
    private final IDataPersistenceService service;

    @Inject
    public EclipseActivityChart(IDataPersistenceService service) {
        this.service = service;
    }

    @Override
    public Chart createChart() {
        ArrayList<String> dayList = new ArrayList<String>();
        ArrayList<Double> numberList = new ArrayList<Double>();
        Map data = WorkbenchData.create((IDataPersistenceService)this.service).getHoursForWeekdays();
        for (WeekDays day : data.keySet()) {
            if (data.get(day) == null) continue;
            Double hoursPerDay = this.convertToHours((Long)data.get(day));
            dayList.add(day.getDay());
            numberList.add(hoursPerDay);
        }
        Map rawData = WorkbenchData.create((IDataPersistenceService)this.service).getRawWeekDayData();
        if (this.getParent() != null) {
            new Label(this.getParent(), 0).setText("Total number of spent hours: " + this.getTotalNumber(rawData));
        }
        String[] names = dayList.toArray(new String[dayList.size()]);
        Double[] values = numberList.toArray(new Double[numberList.size()]);
        return BarChartFactory.create("Weekday Performance", "Hours per Day", names, values);
    }

    private Double convertToHours(long data) {
        double formatHours = (double)data / 3600000.0;
        return (double)Math.round(formatHours * 100.0) / 100.0;
    }

    private double getTotalNumber(Map<WeekDays, List<Long>> rawData) {
        long result = 0L;
        for (WeekDays day : rawData.keySet()) {
            if (rawData.get(day) == null) continue;
            List<Long> list = rawData.get(day);
            for (Long time : list) {
                result += time.longValue();
            }
        }
        return this.convertToHours(result);
    }
}

