/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.recommenders.stats.charts.rcp.charts.BarChartFactory;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.ui.data.GitCommitData;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class GitCommitChart
extends AbstractChartPage {
    private static final String NO_REPO_LABEL = "No repositories found";
    private static final String COMMIT_LABEL = "Total number of commits: ";

    @Override
    public Chart createChart() {
        Set gitRepositories = GitCommitData.readAllGitRepositories();
        String firstRepo = (String)Iterables.getFirst((Iterable)gitRepositories, (Object)"");
        final HashMap<String, Double> commitMap = new HashMap<String, Double>();
        this.readCommitsInBackground(firstRepo, commitMap);
        final ComboViewer combo = new ComboViewer(this.getParent(), 8);
        final Label commitLabel = new Label(this.getParent(), 0);
        commitLabel.setText(COMMIT_LABEL + GitCommitData.getCommitNumber(commitMap));
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this.setComboInput(gitRepositories, firstRepo, combo);
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = combo.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection comboSelection = (IStructuredSelection)selection;
                    String firstElement = (String)comboSelection.getFirstElement();
                    GitCommitChart.this.readCommitsInBackground(firstElement, commitMap);
                    Chart chart = GitCommitChart.this.createBarChart(GitCommitData.sortByValue((Map)commitMap));
                    commitLabel.setText(GitCommitChart.COMMIT_LABEL + GitCommitData.getCommitNumber((Map)commitMap));
                    GitCommitChart.this.setChart(chart);
                    GitCommitChart.this.getParent().redraw();
                }
            }
        });
        return this.createBarChart(GitCommitData.sortByValue(commitMap));
    }

    private void setComboInput(Set<String> gitRepositories, String firstRepo, ComboViewer combo) {
        if (gitRepositories.isEmpty()) {
            combo.setInput((Object)new String[]{NO_REPO_LABEL});
            combo.setSelection((ISelection)new StructuredSelection((Object)NO_REPO_LABEL));
        } else {
            combo.setInput(gitRepositories);
            combo.setSelection((ISelection)new StructuredSelection((Object)firstRepo));
        }
    }

    private void readCommitsInBackground(final String firstRepo, final Map<String, Double> commitMap) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                commitMap.clear();
                commitMap.putAll(GitCommitData.readAllCommits((String)firstRepo));
            }
        });
    }

    private Chart createBarChart(Map<String, Double> commitMap) {
        if (commitMap.isEmpty()) {
            return BarChartFactory.create("No Git repositories found in workspace", "no valid data", new String[]{""}, new Double[]{0.0});
        }
        String[] names = commitMap.keySet().toArray(new String[commitMap.size()]);
        Double[] values = commitMap.values().toArray(new Double[commitMap.size()]);
        return BarChartFactory.create("Commit Overview", "# Commits", names, values);
    }

    private class ComboLabelProvider
    extends LabelProvider {
        private ComboLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return GitCommitData.extractRepoName((String)((String)element));
            }
            return super.getText(element);
        }
    }
}

