/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractShowSpecificationHandler
extends AbstractSelectionBasedHandler {
    protected void showSpecUINode(INodePO node, IViewPart viewPart) {
        if (!this.openSpecPerspectiveAndShowError()) {
            return;
        }
        this.activatViewAndSelect(node, viewPart);
    }

    protected void showSpecUINode(INodePO node, String viewPartID) {
        if (!this.openSpecPerspectiveAndShowError()) {
            return;
        }
        IViewPart viewPart = Plugin.showView(viewPartID);
        this.activatViewAndSelect(node, viewPart);
    }

    private boolean openSpecPerspectiveAndShowError() {
        if (!Utils.openPerspective("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
            return false;
        }
        if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_PERSPECTIVE_CHANGE);
            return false;
        }
        return true;
    }

    private void activatViewAndSelect(INodePO node, IViewPart viewPart) {
        if (viewPart instanceof AbstractJBTreeView) {
            AbstractJBTreeView jbtv = (AbstractJBTreeView)viewPart;
            Plugin.activate((IWorkbenchPart)jbtv);
            UINodeBP.selectNodeInTree(node.getId(), jbtv.getTreeViewer(), jbtv.getEntityManager());
        }
    }
}

