/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.PackageAdmin;

@NonNullByDefault
public class AspectBindingRegistry {
    private static List<String> KNOWN_OTDT_ASPECTS = new ArrayList<String>();
    private static Map<String, ArrayList<AspectBinding>> aspectBindingsByBasePlugin;
    private static Map<String, ArrayList<AspectBinding>> aspectBindingsByAspectPlugin;
    private Map<String, AspectBinding.BaseBundle> baseBundleLookup = new HashMap<String, AspectBinding.BaseBundle>();
    private Set<String> selfAdaptingAspects = new HashSet<String>();
    private Set<String> allAllBoundBaseClasses = new HashSet<String>(1024);
    public static boolean IS_OTDT;

    static {
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.jdt.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.compiler.adaptor");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.refactoring");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.pde.ui");
        KNOWN_OTDT_ASPECTS.add("org.eclipse.objectteams.otdt.samples");
        aspectBindingsByBasePlugin = new HashMap<String, ArrayList<AspectBinding>>();
        aspectBindingsByAspectPlugin = new HashMap<String, ArrayList<AspectBinding>>();
        IS_OTDT = false;
    }

    public boolean isOTDT() {
        return IS_OTDT;
    }

    /*
     * Unable to fully structure code
     */
    public void loadAspectBindings(IExtensionRegistry extensionRegistry, @Nullable PackageAdmin packageAdmin, OTWeavingHook hook) throws DelegatingTransformer.OTAgentNotInstalled {
        aspectBindingConfigs = extensionRegistry.getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "aspectBindings");
        teamLookup = new HashMap<String, Set<AspectBinding.TeamBinding>>();
        bindings = new ArrayList<AspectBinding>(aspectBindingConfigs.length);
        i = 0;
        while (i < aspectBindingConfigs.length) {
            currentBindingConfig = aspectBindingConfigs[i];
            aspectBundleId = currentBindingConfig.getContributor().getName();
            AspectBindingRegistry.IS_OTDT |= AspectBindingRegistry.KNOWN_OTDT_ASPECTS.contains(aspectBundleId);
            aspectBundle = null;
            if (packageAdmin == null) ** GOTO lbl16
            aspectBundles = packageAdmin.getBundles(aspectBundleId, null);
            if (aspectBundles == null || aspectBundles.length == 0 || aspectBundles[0].getState() < 4) {
                TransformerPlugin.log(4, "aspect bundle " + aspectBundleId + " is not resolved - not loading aspectBindings.");
            } else {
                aspectBundle = aspectBundles[0];
lbl16:
                // 2 sources

                if ((basePlugins = currentBindingConfig.getChildren("basePlugin")).length != 1) {
                    TransformerPlugin.log(4, "aspectBinding of " + aspectBundleId + " must declare exactly one basePlugin");
                } else {
                    baseBundleId = basePlugins[0].getAttribute("id");
                    if (baseBundleId == null) {
                        TransformerPlugin.log(4, "aspectBinding of " + aspectBundleId + " must specify the id of a basePlugin");
                    } else {
                        baseBundle = this.getBaseBundle(baseBundleId);
                        fragments = basePlugins[0].getChildren("requiredFragment");
                        if (this.checkRequiredFragments(aspectBundleId, baseBundleId, fragments, packageAdmin)) {
                            teams = currentBindingConfig.getChildren("team");
                            teamCount = teams.length;
                            j = 0;
                            while (j < teams.length) {
                                if (teams[j].getAttribute("class") == null) {
                                    --teamCount;
                                }
                                ++j;
                            }
                            if (teamCount == 0) {
                                TransformerPlugin.log(2, "aspectbinding of " + aspectBundleId + " for base " + baseBundleId + " defines no team class");
                            } else {
                                binding = new AspectBinding(aspectBundleId, aspectBundle, baseBundle, basePlugins[0].getChildren("forcedExports"), teamCount);
                                bindings.add(binding);
                                isSelfAdaptation = baseBundleId.toUpperCase().equals("SELF");
                                try {
                                    j = 0;
                                    count = 0;
                                    while (count < teamCount) {
                                        teamClass = teams[j].getAttribute("class");
                                        if (teamClass != null) {
                                            team = binding.createResolvedTeam(count++, teamClass, teams[j].getAttribute("activation"), teams[j].getAttribute("superclass"));
                                            teamSet = (HashSet<AspectBinding.TeamBinding>)teamLookup.get(teamClass);
                                            if (teamSet == null) {
                                                teamSet = new HashSet<AspectBinding.TeamBinding>();
                                                teamLookup.put(teamClass, teamSet);
                                            }
                                            teamSet.add(team);
                                            var27_33 = teams[j].getChildren("superBase");
                                            var26_32 = var27_33.length;
                                            var25_31 = 0;
                                            while (var25_31 < var26_32) {
                                                superBase = var27_33[var25_31];
                                                superBaseBinding = this.addSuperBase(superBase, aspectBundleId, aspectBundle, baseBundle, team, packageAdmin, hook);
                                                bindings.add(superBaseBinding);
                                                superBaseTeam = superBaseBinding.teams[0];
                                                teamSet.add(superBaseTeam);
                                                ++var25_31;
                                            }
                                        }
                                        ++j;
                                    }
                                    realBaseBundleId = isSelfAdaptation != false ? aspectBundleId : baseBundleId;
                                    AspectBindingRegistry.addBindingForBaseBundle(realBaseBundleId, binding);
                                    this.addBindingForAspectBundle(aspectBundleId, binding);
                                    hook.setBaseTripWire(packageAdmin, realBaseBundleId, baseBundle);
                                    TransformerPlugin.log(1, "registered:\n" + binding);
                                }
                                catch (DelegatingTransformer.OTAgentNotInstalled otani) {
                                    throw otani;
                                }
                                catch (Throwable t) {
                                    TransformerPlugin.log(t, "Invalid aspectBinding extension");
                                }
                                if (packageAdmin != null && aspectBundle != null && !binding.hasScannedTeams && !isSelfAdaptation) {
                                    baseBundles = packageAdmin.getBundles(baseBundleId, null);
                                    if (baseBundles == null || baseBundles.length == 0 || baseBundles[0].getState() < 4) {
                                        TransformerPlugin.log(4, "base bundle " + baseBundleId + " is not resolved - weaving may be incomplete.");
                                    } else {
                                        baseBundleWiring = (BundleWiring)baseBundles[0].adapt(BundleWiring.class);
                                        if (!AspectBindingRegistry.$assertionsDisabled && baseBundleWiring == null) {
                                            throw new AssertionError((Object)"Bundle should adapt to BundleWiring");
                                        }
                                        boundBases = binding.scanTeamClasses(aspectBundle, DelegatingTransformer.newTransformer(binding.weavingScheme, hook, baseBundleWiring));
                                        this.addBoundBaseClasses(boundBases);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        for (AspectBinding binding : bindings) {
            binding.connect(teamLookup);
        }
    }

    private AspectBinding addSuperBase(IConfigurationElement superBase, String aspectBundleId, @Nullable Bundle aspectBundle, AspectBinding.BaseBundle baseBundle, AspectBinding.TeamBinding teamBinding, @Nullable PackageAdmin packageAdmin, OTWeavingHook hook) throws DelegatingTransformer.OTAgentNotInstalled {
        AspectBinding.BaseBundle superBaseBundle;
        String superBaseClass = superBase.getAttribute("class");
        String superBasePlugin = superBase.getAttribute("plugin");
        if (superBaseClass == null) {
            throw new IllegalArgumentException("superBase element must define 'class'");
        }
        if (superBasePlugin == null) {
            superBasePlugin = baseBundle.bundleName;
            superBaseBundle = baseBundle;
        } else {
            superBaseBundle = this.getBaseBundle(superBasePlugin);
        }
        AspectBinding superBinding = new AspectBinding(aspectBundleId, aspectBundle, superBaseBundle, new IConfigurationElement[0], 1);
        AspectBinding.TeamBinding team2 = superBinding.createResolvedTeam(0, teamBinding.teamName, "NONE", teamBinding.superTeamName);
        superBinding.allBaseClassNames.add(superBaseClass);
        team2.baseClassNames.add(superBaseClass);
        AspectBindingRegistry.addBindingForBaseBundle(superBasePlugin, superBinding);
        this.addBindingForAspectBundle(aspectBundleId, superBinding);
        hook.setBaseTripWire(packageAdmin, superBasePlugin, superBaseBundle);
        teamBinding.superBases.add(String.valueOf(superBasePlugin) + '/' + superBaseClass);
        return superBinding;
    }

    private boolean checkRequiredFragments(String aspectBundleId, String baseBundleId, IConfigurationElement[] fragments, @Nullable PackageAdmin packageAdmin) {
        boolean hasError = false;
        IConfigurationElement[] iConfigurationElementArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fragment = iConfigurationElementArray[n2];
            String fragId = fragment.getAttribute("id");
            if (fragId == null) {
                TransformerPlugin.log(4, "Mandatory attribute \"id\" missing from element \"requiredFragment\" of aspect binding in " + aspectBundleId);
                return false;
            }
            if (packageAdmin == null) {
                TransformerPlugin.log(4, "Not checking required fragment " + fragId + " in aspect binding of " + aspectBundleId + ", package admin service not present");
                return false;
            }
            Bundle[] fragmentBundles = packageAdmin.getBundles(fragId, null);
            if (fragmentBundles == null || fragmentBundles.length == 0) {
                TransformerPlugin.log(4, "Required fragment " + fragId + " not found in aspect binding of " + aspectBundleId);
                hasError = true;
            } else {
                Bundle fragmentBundle = fragmentBundles[0];
                String aspectBindingHint = " (aspect binding of " + aspectBundleId + ")";
                if (packageAdmin.getBundleType(fragmentBundle) != 1) {
                    TransformerPlugin.log(4, "Required fragment " + fragId + " is not a fragment" + aspectBindingHint);
                    hasError = true;
                } else {
                    Bundle[] hosts = packageAdmin.getHosts(fragmentBundle);
                    if (hosts == null || hosts.length == 0) {
                        if (fragmentBundle.getState() < 4) {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " is not resolved" + aspectBindingHint);
                            hasError = true;
                        } else {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " has no host bundle" + aspectBindingHint);
                            hasError = true;
                        }
                    } else {
                        Bundle host = hosts[0];
                        if (!host.getSymbolicName().equals(baseBundleId)) {
                            TransformerPlugin.log(4, "Required fragment " + fragId + " has wrong host " + host.getSymbolicName() + aspectBindingHint);
                            hasError = true;
                        }
                    }
                }
            }
            ++n2;
        }
        return !hasError;
    }

    private static void addBindingForBaseBundle(String baseBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByBasePlugin.get(baseBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByBasePlugin.put(baseBundleId, bindingList);
        }
        bindingList.add(binding);
    }

    private void addBindingForAspectBundle(String aspectBundleId, AspectBinding binding) {
        ArrayList<AspectBinding> bindingList = aspectBindingsByAspectPlugin.get(aspectBundleId);
        if (bindingList == null) {
            bindingList = new ArrayList();
            aspectBindingsByAspectPlugin.put(aspectBundleId, bindingList);
        }
        bindingList.add(binding);
        if (binding.basePluginName.toUpperCase().equals("SELF")) {
            this.selfAdaptingAspects.add(aspectBundleId);
        }
    }

    public String @Nullable [] getAdaptedBasePlugins(Bundle aspectBundle) {
        List bindings = aspectBindingsByAspectPlugin.get(aspectBundle.getSymbolicName());
        if (bindings == null) {
            return null;
        }
        String[] basePlugins = new String[bindings.size()];
        int i = 0;
        while (i < basePlugins.length) {
            basePlugins[i] = ((AspectBinding)bindings.get((int)i)).basePluginName;
            ++i;
        }
        return basePlugins;
    }

    public boolean isAdaptedBasePlugin(@Nullable String symbolicName) {
        ArrayList<AspectBinding> list = aspectBindingsByBasePlugin.get(symbolicName);
        return list != null && !list.isEmpty();
    }

    public boolean isBoundBaseClass(String className) {
        return this.allAllBoundBaseClasses.contains(className);
    }

    public void addBoundBaseClasses(Collection<String> boundBaseclassNames) {
        this.allAllBoundBaseClasses.addAll(boundBaseclassNames);
    }

    public @Nullable List<AspectBinding> getAdaptingAspectBindings(@Nullable String basePluginName) {
        return aspectBindingsByBasePlugin.get(basePluginName);
    }

    public @Nullable List<AspectBinding> getAspectBindings(String aspectBundle) {
        return aspectBindingsByAspectPlugin.get(aspectBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectBinding.BaseBundle getBaseBundle(String bundleName) {
        Map<String, AspectBinding.BaseBundle> map = this.baseBundleLookup;
        synchronized (map) {
            AspectBinding.BaseBundle bundle = this.baseBundleLookup.get(bundleName);
            if (bundle == null) {
                bundle = new AspectBinding.BaseBundle(bundleName);
                this.baseBundleLookup.put(bundleName, bundle);
            }
            return bundle;
        }
    }
}

