/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.papyrus.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.papyrus.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IColor;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custompt.Alignment;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custompt.Shadow;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomOverride;
import org.eclipse.papyrus.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.ImageManager;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.PropertiesHandler;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.util.core.DebugUtils;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.swt.colorprovider.IColorProvider;
import org.eclipse.papyrus.emf.facet.util.swt.colorprovider.IColorProviderFactory;
import org.eclipse.papyrus.emf.facet.util.swt.fontprovider.IFontProvider;
import org.eclipse.papyrus.emf.facet.util.swt.fontprovider.IFontProviderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CustomizedLabelProvider
extends CellLabelProvider
implements ICustomizedLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final boolean DEBUG_FONT = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"font");
    private static final boolean DEBUG_COLOR = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"color");
    private static final int RGB_MAX = 255;
    private static final RGB DEFAULT_BCKGND = new RGB(255, 255, 255);
    private static final RGB DEFAULT_FOREGND = new RGB(0, 0, 0);
    private final ICustomizationManager customManager;
    private final PropertiesHandler propertiesHandler;
    private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    private final ImageManager imageManager;
    private final ICustomOverride customOverride;

    @Deprecated
    public CustomizedLabelProvider(ResourceSet resourceSet) {
        this(ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(resourceSet));
    }

    public CustomizedLabelProvider(ICustomizationManager customManager) {
        this.customManager = customManager;
        this.propertiesHandler = new PropertiesHandler(customManager);
        this.imageManager = new ImageManager();
        this.customOverride = CustomizedLabelProvider.getICustomOverride();
    }

    private <T> T getPropertyValue(Object element, FacetOperation property, ETypedElement eTypedElement, Class<T> classs) {
        return (T)CustomizationUtils.getPropertyValue((ICustomizationManager)this.customManager, (Object)element, (FacetOperation)property, (ETypedElement)eTypedElement, classs);
    }

    public String getText(Object element) {
        String result;
        if (element instanceof EObject) {
            result = this.getPropertyValue(element, this.propertiesHandler.getLabelProperty(), null, String.class);
        } else if (element == null) {
            result = Messages.CustomizedLabelProvider_null;
        } else if (element instanceof List) {
            StringBuffer strBuffer = new StringBuffer();
            List list = (List)element;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object current = iter.next();
                strBuffer.append(this.getText(current));
                if (!iter.hasNext()) continue;
                strBuffer.append(", ");
            }
            result = strBuffer.toString();
        } else {
            result = element.toString();
        }
        if (this.customOverride != null) {
            try {
                result = this.customOverride.getText(result, element, this.customManager, this.propertiesHandler);
            }
            catch (CustomizationException e) {
                result = "ERROR, cf. log";
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    @Override
    public StyledString getStyledText(Object element) {
        StyledString result = null;
        if (element instanceof EObject) {
            result = this.getPropertyValue(element, this.propertiesHandler.getLabelProperty(), null, StyledString.class);
            if (result instanceof String) {
                result = new StyledString((String)result);
            }
        } else {
            result = new StyledString(this.getText(element));
        }
        return result;
    }

    private static ICustomOverride getICustomOverride() {
        Bundle bundle = Activator.getDefault().getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ICustomOverride.class.getName());
        ICustomOverride customOverride = (ICustomOverride)bundleContext.getService(serviceReference);
        return customOverride;
    }

    @Override
    public String getText(Object object, ETypedElement eTypedElement) {
        String result = null;
        if (object == null) {
            result = Messages.CustomizedLabelProvider_null;
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                Object objectResult = this.customManager.getCustomValueOf(eObject, eTypedElement, this.propertiesHandler.getLabelProperty(), Object.class);
                if (objectResult instanceof StyledString) {
                    result = objectResult.toString();
                } else if (objectResult instanceof String) {
                    result = (String)objectResult;
                }
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                result = "!!! Error, cf log !!!";
            }
        } else {
            result = object.toString();
        }
        return result;
    }

    @Override
    public StyledString getStyledText(Object object, ETypedElement eTypedElement) {
        StyledString result = null;
        if (object == null) {
            result = new StyledString(Messages.CustomizedLabelProvider_null);
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                Object objectResult = this.customManager.getCustomValueOf(eObject, eTypedElement, this.propertiesHandler.getLabelProperty(), Object.class);
                if (objectResult instanceof StyledString) {
                    result = (StyledString)objectResult;
                } else if (objectResult instanceof String) {
                    result = new StyledString((String)objectResult);
                }
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                result = new StyledString("!!! Error, cf log !!!");
            }
        } else {
            result = new StyledString(object.toString());
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private static Color getColor(RGB rgb) {
        Display display = Display.getDefault();
        IColorProvider colorProvider = IColorProviderFactory.DEFAULT.getOrCreateIColorProvider((Device)display);
        return colorProvider.getColor(rgb);
    }

    public Color getForeground(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getForegroundProperty(), null, IColor.class);
        Color result = color == null ? CustomizedLabelProvider.getColor(DEFAULT_FOREGND) : CustomizedLabelProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        return result;
    }

    public Color getBackground(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getBackgroundProperty(), null, IColor.class);
        Color result = color == null ? CustomizedLabelProvider.getColor(DEFAULT_BCKGND) : CustomizedLabelProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        return result;
    }

    private Font getFont(FontData fontData) {
        IFontProvider fontProvider = IFontProviderFactory.DEFAULT.getOrCreateIFontProvider((Device)Display.getDefault());
        return fontProvider.getFont(fontData);
    }

    public Font getFont(Object element) {
        Boolean isItalic;
        Boolean isBold;
        Integer fontSize;
        String fontName = this.getPropertyValue(element, this.propertiesHandler.getFontNameProperty(), null, String.class);
        if (fontName == null) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            fontName = fontData[0].getName();
        }
        if ((fontSize = this.getPropertyValue(element, this.propertiesHandler.getFontSizeProperty(), null, Integer.class)) == null) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            fontSize = fontData[0].getHeight();
        }
        if ((isBold = this.getPropertyValue(element, this.propertiesHandler.getIsBoldProperty(), null, Boolean.class)) == null) {
            isBold = Boolean.FALSE;
        }
        if ((isItalic = this.getPropertyValue(element, this.propertiesHandler.getIsItalicProperty(), null, Boolean.class)) == null) {
            isItalic = Boolean.FALSE;
        }
        int fontStyle = 0;
        if (isBold.booleanValue()) {
            fontStyle |= 1;
        }
        if (isItalic.booleanValue()) {
            fontStyle |= 2;
        }
        FontData fontData = new FontData(fontName, fontSize.intValue(), fontStyle);
        try {
            fontData = this.customOverride.getFont(fontData, element, this.customManager, this.propertiesHandler);
        }
        catch (CustomizationException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return this.getFont(fontData);
    }

    public Image getImage(Object element) {
        IImage image = this.getPropertyValue(element, this.propertiesHandler.getImageProperty(), null, IImage.class);
        return this.imageManager.getImage(image);
    }

    @Override
    public Image getImage(Object element, ETypedElement featureColumn) {
        return this.getImage(element, this.propertiesHandler.getImageProperty(), featureColumn);
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    @Override
    public boolean isUnderlined(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getIsUnderlinedProperty(), null, Boolean.class);
    }

    @Override
    public boolean isStruckthrough(Object element, ETypedElement eTypedElement) {
        Boolean propertyValue = this.getPropertyValue(element, this.propertiesHandler.getIsStruckthroughProperty(), eTypedElement, Boolean.class);
        boolean result = false;
        if (propertyValue != null) {
            result = propertyValue;
        }
        return result;
    }

    private Image getImage(Object element, FacetOperation operation, ETypedElement feature) {
        IImage iimage = this.getPropertyValue(element, operation, feature, IImage.class);
        return this.imageManager.getImage(iimage);
    }

    @Override
    public Image getTopLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopLeftOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getTopMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopMiddleOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getTopRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopRightOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomLeftOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomMiddleOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomRightOverlayProperty(), eTypedElement);
    }

    public String getToolTipText(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTextProperty(), null, String.class);
    }

    public int getToolTipStyle(Object element) {
        int style = 0;
        Shadow shadow = this.getPropertyValue(element, this.propertiesHandler.getToolTipShadowProperty(), null, Shadow.class);
        switch (shadow) {
            case NONE: {
                style = 32;
                break;
            }
            case IN: {
                style = 4;
                break;
            }
            case OUT: {
                style = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Un expected value");
            }
        }
        Alignment alignment = this.getPropertyValue(element, this.propertiesHandler.getToolTipAlignmentProperty(), null, Alignment.class);
        switch (alignment) {
            case LEFT: {
                style |= 0x4000;
                break;
            }
            case CENTER: {
                style |= 0x1000000;
                break;
            }
            case RIGHT: {
                style |= 0x20000;
                break;
            }
            default: {
                throw new IllegalStateException("Un expected value");
            }
        }
        return style;
    }

    public Image getToolTipImage(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipImageProperty(), null, Image.class);
    }

    public Color getToolTipBackgroundColor(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getToolTipBackgroundProperty(), null, IColor.class);
        return CustomizedLabelProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public Color getToolTipForegroundColor(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getToolTipForegroundProperty(), null, IColor.class);
        return CustomizedLabelProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
    }

    @Override
    public Image getToolTipTopLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopLeftOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipTopMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopMiddleOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipTopRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopRightOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomLeftOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomMiddleOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomRightOverlayProperty(), null, Image.class);
    }

    public int getToolTipDisplayDelayTime(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipDisplayDelayTimeProperty(), null, Integer.class);
    }

    public int getToolTipTimeDisplayed(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTimeDisplayedProperty(), null, Integer.class);
    }

    public Font getToolTipFont(Object element) {
        String fontName = this.getPropertyValue(element, this.propertiesHandler.getToolTipFontNameProperty(), null, String.class);
        Integer fontSize = this.getPropertyValue(element, this.propertiesHandler.getToolTipFontSizeProperty(), null, Integer.class);
        Boolean isBold = this.getPropertyValue(element, this.propertiesHandler.getToolTipIsBoldProperty(), null, Boolean.class);
        Boolean isItalic = this.getPropertyValue(element, this.propertiesHandler.getToolTipIsItalicProperty(), null, Boolean.class);
        int fontStyle = 0;
        if (isBold.booleanValue()) {
            fontStyle |= 1;
        }
        if (isItalic.booleanValue()) {
            fontStyle |= 2;
        }
        FontData fontData = new FontData(fontName, fontSize.intValue(), fontStyle);
        IFontProvider fontProvider = IFontProviderFactory.DEFAULT.getOrCreateIFontProvider((Device)Display.getDefault());
        return fontProvider.getFont(fontData);
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        cell.setBackground(this.getBackground(element));
        cell.setFont(this.getFont(element));
        cell.setForeground(this.getForeground(element));
        cell.setImage(this.getImage(element));
    }

    @Override
    public String getToolTipText(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Image getToolTipImage(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Font getToolTipFont(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Color getToolTipBackgroundColor(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Color getToolTipForegroundColor(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public int getToolTipTimeDisplayed(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public int getToolTipDisplayDelayTime(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public int getToolTipStyle(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public ICustomizedLabelProvider cloneLabelProvider() {
        return new CustomizedLabelProvider(this.customManager);
    }
}

