/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.internal;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFacetValidator
extends EObjectValidator {
    private static final String IMAGE_OVERRIDE = "image";
    private static final String LABEL_OVERRIDE = "label";
    public static EFacetValidator eInstance = new EFacetValidator();

    protected EPackage getEPackage() {
        return EFacetPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 2: {
                return this.validateOperation((FacetOperation)value, diagnostics, context);
            }
        }
        return super.validate(classifierID, value, diagnostics, context);
    }

    private boolean validateOperation(FacetOperation facetOperation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(facetOperation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(facetOperation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateOperation_validate(facetOperation, diagnostics, context);
        }
        return result;
    }

    private boolean validateOperation_validate(FacetOperation facetOperation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean valid = true;
        if (diagnostics != null && facetOperation.getOverride() != null && (facetOperation.getOverride().getName().equals(LABEL_OVERRIDE) || facetOperation.getOverride().getName().equals(IMAGE_OVERRIDE))) {
            if (facetOperation.getEParameters().size() != 1) {
                valid = false;
            }
            if (!((EClass)((EParameter)facetOperation.getEParameters().get(0)).getEType()).equals(EcorePackage.eINSTANCE.getEReference())) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 1, "The operation " + facetOperation.getName() + " that overrides 'label'must have a parameter typed by EReference '", new Object[]{facetOperation}));
                valid = false;
            }
        }
        return valid;
    }
}

