/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.controlmode.commands;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.controlmode.Activator;
import org.eclipse.papyrus.infra.nattable.controlmode.helpers.TableControlModeHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;

public class PapyrusNattableControlCommand
extends AbstractTransactionalCommand {
    protected ControlModeRequest request;

    public PapyrusNattableControlCommand(ControlModeRequest request) {
        super(request.getEditingDomain(), "Move table to new resource", null);
        this.request = request;
        try {
            this.getAffectedFiles().addAll(PapyrusNattableControlCommand.getWorkspaceFiles(this.getTables()));
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected List<EObject> getTables() throws ExecutionException {
        return Lists.newArrayList(TableControlModeHelper.createDescendantTablesIterable(this.request.getTargetObject()));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject objectTOControl = this.request.getTargetObject();
        EMFHelper.getUsages((EObject)objectTOControl);
        Resource newResource = this.getTargetResource();
        if (newResource == null) {
            return CommandResult.newErrorCommandResult((String)String.format("The target %s model has not been created", this.getTargetResourceFileExtension()));
        }
        List<EObject> tables = this.getTables();
        if (!tables.isEmpty()) {
            for (EObject tab : tables) {
                if (!(tab instanceof Table)) continue;
                newResource.getContents().add((Object)tab);
            }
            this.addMovedTabToRequest(tables);
        }
        return CommandResult.newOKCommandResult((Object)newResource);
    }

    public void addMovedTabToRequest(List<EObject> tables) {
        ArrayList<EObject> openables = (ArrayList<EObject>)this.request.getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (openables == null) {
            openables = new ArrayList<EObject>();
        }
        openables.addAll(tables);
        this.request.addParameters(Collections.singletonMap("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables", openables));
    }

    protected Resource getTargetResource() {
        return this.request.getTargetResource(this.getTargetResourceFileExtension());
    }

    protected String getTargetResourceFileExtension() {
        return "notation";
    }
}

