/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.MessageLostEditPart;

public class CustomLifelineCompartmentGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected INodeEditPart getConnectionCompleteEditPart(Request request) {
        return (INodeEditPart)this.getHost().getParent();
    }

    protected INodeEditPart getConnectableEditPart() {
        return (INodeEditPart)this.getHost().getParent();
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart instanceof MessageLostEditPart) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            IFigure sourceFigure = ((GraphicalEditPart)connectionEditPart.getSource()).getFigure();
            return MessageUtils.createMoveMessageAnchorCommand((LocationRequest)request, connectionEditPart, sourceFigure, Messages.CustomLifelineCompartmentGraphicalNodeEditPolicy_SetMessageLostTargetLocation, editingDomain);
        }
        return super.getReconnectTargetCommand(request);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart instanceof MessageFoundEditPart) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            IFigure targetFigure = ((GraphicalEditPart)connectionEditPart.getTarget()).getFigure();
            return MessageUtils.createMoveMessageAnchorCommand((LocationRequest)request, connectionEditPart, targetFigure, Messages.CustomLifelineCompartmentGraphicalNodeEditPolicy_SetMessageFoundSourceLocation, editingDomain);
        }
        return super.getReconnectTargetCommand(request);
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        return new XYAnchor(new Point(request.getLocation()));
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        Point startLocation = MessageUtils.retrieveRequestStartLocation((CreateRequest)request);
        if (startLocation != null) {
            return new XYAnchor(new Point(startLocation));
        }
        return super.getSourceConnectionAnchor(request);
    }
}

