/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeArrows;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.EdgeRoutingStyleChangedCommand;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.draw2d.figure.PolygoneAndPolylineDecoraction;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class DiagramEdgeEditPartOperation {
    public static final PointList INVERSE_TRIANGLE_TIP = new PointList();
    private static final int ZOOM_ERROR_MARGIN = 4;

    static {
        INVERSE_TRIANGLE_TIP.addPoint(1, -1);
        INVERSE_TRIANGLE_TIP.addPoint(0, 0);
        INVERSE_TRIANGLE_TIP.addPoint(1, 1);
    }

    private DiagramEdgeEditPartOperation() {
    }

    public static NotificationPreCommitListener createEAdapterRoutingStyle(final IDiagramEdgeEditPart self) {
        return new NotificationPreCommitListener(){

            public Command transactionAboutToCommit(Notification msg) {
                return new EdgeRoutingStyleChangedCommand(self.getEditingDomain(), self, msg);
            }
        };
    }

    public static void routingStyleChanged(IDiagramEdgeEditPart self, Notification message) {
        if (self.isActive() && message.getFeature() == NotationPackage.eINSTANCE.getRoutingStyle_Routing()) {
            RoutingStyle rstyle = (RoutingStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
            EdgeRouting routing = DiagramEdgeEditPartOperation.convertEdgeRoutingStyle(rstyle);
            DEdge graphicalSemanticEdge = (DEdge)self.resolveSemanticElement();
            if (((EdgeStyle)graphicalSemanticEdge.getStyle()).getRoutingStyle() != routing) {
                ((EdgeStyle)graphicalSemanticEdge.getStyle()).setRoutingStyle(routing);
                EList customFeatures = graphicalSemanticEdge.getStyle().getCustomFeatures();
                String featureName = DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName();
                if (!customFeatures.contains(featureName)) {
                    customFeatures.add(featureName);
                }
            }
            if (routing == EdgeRouting.TREE_LITERAL && rstyle.getJumpLinkStatus() != JumpLinkStatus.NONE_LITERAL) {
                self.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)self.getEditingDomain(), (Object)rstyle, (Object)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkStatus(), (Object)0));
            } else if (routing != EdgeRouting.TREE_LITERAL && rstyle.getJumpLinkStatus() != JumpLinkStatus.ABOVE_LITERAL) {
                self.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)self.getEditingDomain(), (Object)rstyle, (Object)NotationPackage.eINSTANCE.getRoutingStyle_JumpLinkStatus(), (Object)3));
            }
        }
    }

    private static EdgeRouting convertEdgeRoutingStyle(RoutingStyle rstyle) {
        EdgeRouting routing;
        switch (rstyle.getRouting().getValue()) {
            case 0: {
                routing = EdgeRouting.STRAIGHT_LITERAL;
                break;
            }
            case 1: {
                routing = EdgeRouting.MANHATTAN_LITERAL;
                break;
            }
            case 2: {
                routing = EdgeRouting.TREE_LITERAL;
                break;
            }
            default: {
                SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DiagramEdgeEditPartOperation_unknownRountingStyle, rstyle.getRouting().getName()), null);
                routing = EdgeRouting.STRAIGHT_LITERAL;
            }
        }
        return routing;
    }

    public static void refreshVisuals(IDiagramEdgeEditPart self) {
        self.refreshForegroundColor();
        self.refreshSourceDecoration();
        self.refreshTargetDecoration();
        self.refreshLineStyle();
    }

    public static void refreshFont(IDiagramEdgeEditPart self) {
        for (Object child : self.getChildren()) {
            if (!(child instanceof IDiagramNameEditPart)) continue;
            DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)child);
        }
    }

    public static void refreshForegroundColor(IDiagramEdgeEditPart self) {
        DEdge edge;
        EObject diagramElement = self.resolveSemanticElement();
        if (diagramElement instanceof DEdge && (edge = (DEdge)diagramElement).getOwnedStyle() != null && edge.getOwnedStyle().getStrokeColor() != null) {
            RGBValues rgb = edge.getOwnedStyle().getStrokeColor();
            self.getPolylineConnectionFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
        }
    }

    public static void refreshSourceDecoration(IDiagramEdgeEditPart self) {
        DEdge edge;
        EObject diagramElement;
        if (!DiagramEdgeEditPartOperation.isSelected((EditPart)self) && !DiagramEdgeEditPartOperation.isLabelSelected(self) && (diagramElement = self.resolveSemanticElement()) instanceof DEdge && (edge = (DEdge)diagramElement).getOwnedStyle() != null) {
            EdgeStyle style = edge.getOwnedStyle();
            EdgeArrows arrowsKind = style.getSourceArrow();
            self.getPolylineConnectionFigure().setSourceDecoration(DiagramEdgeEditPartOperation.createArrowDecoration(self, arrowsKind));
        }
    }

    public static void refreshTargetDecoration(IDiagramEdgeEditPart self) {
        DEdge edge;
        EObject diagramElement;
        if (!DiagramEdgeEditPartOperation.isSelected((EditPart)self) && !DiagramEdgeEditPartOperation.isLabelSelected(self) && (diagramElement = self.resolveSemanticElement()) instanceof DEdge && (edge = (DEdge)diagramElement).getOwnedStyle() != null) {
            EdgeStyle style = edge.getOwnedStyle();
            EdgeArrows arrowsKind = style.getTargetArrow();
            self.getPolylineConnectionFigure().setTargetDecoration(DiagramEdgeEditPartOperation.createArrowDecoration(self, arrowsKind));
        }
    }

    private static RotatableDecoration createArrowDecoration(IDiagramEdgeEditPart self, EdgeArrows arrowKind) {
        PolygonDecoration result;
        switch (arrowKind) {
            case NO_DECORATION_LITERAL: {
                result = null;
                break;
            }
            case DIAMOND_LITERAL: {
                result = DiagramEdgeEditPartOperation.createDiamondDecoration(self);
                break;
            }
            case FILL_DIAMOND_LITERAL: {
                result = DiagramEdgeEditPartOperation.createFillDiamondDecoration(self);
                break;
            }
            case INPUT_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createArrowIn(self);
                break;
            }
            case INPUT_CLOSED_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createClosedArrowIn(self);
                break;
            }
            case INPUT_FILL_CLOSED_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createFillClosedArrowIn(self);
                break;
            }
            case OUTPUT_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createArrowOut(self);
                break;
            }
            case OUTPUT_CLOSED_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createClosedArrowOut(self);
                break;
            }
            case OUTPUT_FILL_CLOSED_ARROW_LITERAL: {
                result = DiagramEdgeEditPartOperation.createFillClosedArrowOut(self);
                break;
            }
            case INPUT_ARROW_WITH_DIAMOND_LITERAL: {
                result = DiagramEdgeEditPartOperation.createArrowInWithDiamond(self);
                break;
            }
            case INPUT_ARROW_WITH_FILL_DIAMOND_LITERAL: {
                result = DiagramEdgeEditPartOperation.createArrowInWithFillDiamond(self);
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public static void refreshLineStyle(IDiagramEdgeEditPart self) {
        EObject semanticElement = self.resolveSemanticElement();
        PolylineConnectionEx polylineConnectionFigure = self.getPolylineConnectionFigure();
        if (semanticElement instanceof DEdge && polylineConnectionFigure != null) {
            int lineWidth;
            DEdge edge = (DEdge)semanticElement;
            if (edge.getOwnedStyle() != null) {
                EdgeStyle style = edge.getOwnedStyle();
                DiagramElementEditPartOperation.setLineStyle((Shape)polylineConnectionFigure, style.getLineStyle(), true);
            }
            if (!DiagramEdgeEditPartOperation.isSelected((EditPart)self) && !DiagramEdgeEditPartOperation.isLabelSelected(self) && ((lineWidth = DiagramEdgeEditPartOperation.getLineWidth(edge)) != 0 || lineWidth == 0 && polylineConnectionFigure.getLineWidth() != 1)) {
                polylineConnectionFigure.setLineWidth(DiagramEdgeEditPartOperation.getLineWidth(edge));
            }
        }
    }

    public static int getLineWidth(IDiagramEdgeEditPart self) {
        EObject semanticElement = self.resolveSemanticElement();
        if (semanticElement instanceof DEdge) {
            DEdge edge = (DEdge)semanticElement;
            return DiagramEdgeEditPartOperation.getLineWidth(edge);
        }
        return 0;
    }

    private static int getLineWidth(DEdge edge) {
        int size;
        Integer sizeObject = edge.getStyle() != null ? ((EdgeStyle)edge.getStyle()).getSize() : null;
        int n = size = sizeObject != null ? sizeObject : 0;
        if (size < 1) {
            size = 1;
        }
        return VisualBindingManager.getDefault().getLineWidthFromValue(size);
    }

    private static Point getPointFor(EdgeTarget edgeTarget, IDiagramEdgeEditPart self) {
        View view = null;
        Map editPartRegistry = self.getRoot().getViewer().getEditPartRegistry();
        for (View currentView : DiagramEdgeEditPartOperation.getViews((EObject)edgeTarget, self)) {
            EditPart editPart;
            if (!currentView.isVisible() || !((editPart = (EditPart)editPartRegistry.get(currentView)) instanceof IAbstractDiagramNodeEditPart)) continue;
            view = currentView;
            break;
        }
        EditPart part = (EditPart)editPartRegistry.get(view);
        if (part instanceof GraphicalEditPart && part.getModel() instanceof Node) {
            IFigure figure = ((GraphicalEditPart)part).getFigure();
            Point center = figure.getBounds().getCenter();
            figure.translateToAbsolute((Translatable)center);
            return center;
        }
        return null;
    }

    private static Collection<View> getViews(EObject semanticElement, IDiagramEdgeEditPart self) {
        EObject rootView = EcoreUtil.getRootContainer((EObject)self.getPrimaryView());
        LinkedList<View> views = new LinkedList<View>();
        TreeIterator allView = rootView.eAllContents();
        while (allView.hasNext()) {
            EObject element;
            Object current = allView.next();
            if (!(current instanceof View) || (element = ViewUtil.resolveSemanticElement((View)((View)current))) == null || !element.equals(semanticElement)) continue;
            views.add((View)current);
        }
        return views;
    }

    private static DiagramEventBroker getDiagramEventBroker(IDiagramEdgeEditPart self) {
        TransactionalEditingDomain theEditingDomain = self.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public static void activate(IDiagramEdgeEditPart self) {
        DiagramEventBroker broker = DiagramEdgeEditPartOperation.getDiagramEventBroker(self);
        RoutingStyle rstyle = (RoutingStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        broker.addNotificationListener((EObject)rstyle, self.getEAdapterRoutingStyle());
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(self.getEditingDomain().getResourceSet());
        auth.addAuthorityListener((IAuthorityListener)self.getEditPartAuthorityListener());
        self.getEditPartAuthorityListener().refreshEditMode();
    }

    public static void deactivate(IDiagramEdgeEditPart self) {
        DiagramEventBroker broker = DiagramEdgeEditPartOperation.getDiagramEventBroker(self);
        if (self.getModel() != null && self.getNotationView().getStyle(NotationPackage.eINSTANCE.getRoutingStyle()) != null) {
            RoutingStyle rstyle = (RoutingStyle)self.getNotationView().getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
            broker.removeNotificationListener((EObject)rstyle, self.getEAdapterRoutingStyle());
        }
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(self.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)self.getEditPartAuthorityListener());
    }

    public static PolygonDecoration createFillDiamondDecoration(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-2, 0);
        decorationPointList.addPoint(-1, -1);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(6.0, 3.0);
        DiagramEdgeEditPartOperation.applyLineWidth((Polyline)decoration, self);
        return decoration;
    }

    public static PolygonDecoration createDiamondDecoration(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = DiagramEdgeEditPartOperation.createFillDiamondDecoration(self);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    public static PolygonDecoration createClosedArrowIn(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = DiagramEdgeEditPartOperation.createFillClosedArrowIn(self);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    public static PolygonDecoration createFillClosedArrowIn(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setScale(8.0, 4.0);
        DiagramEdgeEditPartOperation.applyLineWidth((Polyline)decoration, self);
        return decoration;
    }

    public static PolygonDecoration createClosedArrowOut(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = DiagramEdgeEditPartOperation.createClosedArrowIn(self);
        decoration.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
        return decoration;
    }

    public static PolygonDecoration createFillClosedArrowOut(IDiagramEdgeEditPart self) {
        PolygonDecoration decoration = DiagramEdgeEditPartOperation.createFillClosedArrowIn(self);
        decoration.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
        return decoration;
    }

    private static void applyLineWidth(Polyline decoration, IDiagramEdgeEditPart self) {
        DEdge edge = (DEdge)self.resolveSemanticElement();
        int size = DiagramEdgeEditPartOperation.getLineWidth(edge);
        if (size != 0) {
            decoration.setLineWidth(size);
        }
    }

    public static PolylineDecoration createArrowIn(IDiagramEdgeEditPart self) {
        PolylineDecoration decoration = new PolylineDecoration();
        DiagramEdgeEditPartOperation.applyLineWidth((Polyline)decoration, self);
        return decoration;
    }

    public static PolylineDecoration createArrowOut(IDiagramEdgeEditPart self) {
        PolylineDecoration decoration = new PolylineDecoration();
        DiagramEdgeEditPartOperation.applyLineWidth((Polyline)decoration, self);
        decoration.setTemplate(INVERSE_TRIANGLE_TIP);
        return decoration;
    }

    private static RotatableDecoration createArrowInWithDiamond(IDiagramEdgeEditPart self) {
        PolygoneAndPolylineDecoraction decoration = (PolygoneAndPolylineDecoraction)DiagramEdgeEditPartOperation.createArrowInWithFillDiamond(self);
        decoration.setBackgroundColor(ColorConstants.white);
        return decoration;
    }

    private static RotatableDecoration createArrowInWithFillDiamond(IDiagramEdgeEditPart self) {
        PolygoneAndPolylineDecoraction decoration = new PolygoneAndPolylineDecoraction();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-2, 0);
        decorationPointList.addPoint(-1, -1);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(6.0, 3.0);
        DiagramEdgeEditPartOperation.applyLineWidth((Polyline)decoration, self);
        return decoration;
    }

    public static void removeLabel(IDiagramEdgeEditPart self, List<?> modelChildren) {
        EObject label = null;
        Iterator<?> iterChildren = modelChildren.iterator();
        while (iterChildren.hasNext() && label == null) {
            int visualId;
            Object current = iterChildren.next();
            if (!(current instanceof View) || (visualId = SiriusVisualIDRegistry.getVisualID(((View)current).getType())) != 6001) continue;
            label = (EObject)current;
        }
        if (label != null) {
            modelChildren.remove(label);
        }
    }

    protected static DEdgeNameEditPart getLabel(IDiagramEdgeEditPart self) {
        DEdgeNameEditPart label = null;
        Iterator iterChildren = self.getChildren().iterator();
        while (iterChildren.hasNext() && label == null) {
            Object current = iterChildren.next();
            if (!(current instanceof DEdgeNameEditPart)) continue;
            label = (DEdgeNameEditPart)current;
        }
        return label;
    }

    public static boolean isLabelSelected(IDiagramEdgeEditPart self) {
        DEdgeNameEditPart label = DiagramEdgeEditPartOperation.getLabel(self);
        if (label == null) {
            return false;
        }
        return DiagramEdgeEditPartOperation.isSelected((EditPart)label);
    }

    public static boolean isSelected(EditPart self) {
        return self.getSelected() == 2 || self.getSelected() == 1;
    }

    public static void refreshBendpointsWithPath(AbstractDiagramEdgeEditPart self, DEdge edge) {
        RelativeBendpoints bendpoints = (RelativeBendpoints)((Edge)self.getModel()).getBendpoints();
        List modelConstraint = bendpoints.getPoints();
        ArrayList<RelativeBendpoint> defaultFigureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint wbp = (org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(self.getConnectionFigure());
            rbp.setRelativeDimensions(new Dimension(wbp.getSourceX(), wbp.getSourceY()), new Dimension(wbp.getTargetX(), wbp.getTargetY()));
            rbp.setWeight((float)(i + 1) / ((float)modelConstraint.size() + 1.0f));
            defaultFigureConstraint.add(rbp);
            ++i;
        }
        ArrayList<Point> defaultConstraintPoints = new ArrayList<Point>();
        for (RelativeBendpoint relativeBendpointFigureConstraint : defaultFigureConstraint) {
            Point location = relativeBendpointFigureConstraint.getLocation().getCopy();
            defaultConstraintPoints.add(location);
        }
        LinkedList<AbsoluteBendpoint> mandatoryPoints = new LinkedList<AbsoluteBendpoint>();
        boolean allMandatoryPointsAlreadyExist = true;
        for (EdgeTarget current : edge.getPath()) {
            Point point = DiagramEdgeEditPartOperation.getPointFor(current, self);
            if (point == null) continue;
            self.getPolylineConnectionFigure().translateToRelative((Translatable)point);
            AbsoluteBendpoint mandatoryPoint = new AbsoluteBendpoint(point);
            mandatoryPoints.add(mandatoryPoint);
            boolean bl = allMandatoryPointsAlreadyExist = allMandatoryPointsAlreadyExist && DiagramEdgeEditPartOperation.isContainsBy(mandatoryPoint.getLocation(), defaultConstraintPoints, 4);
        }
        if (!allMandatoryPointsAlreadyExist) {
            LinkedList<AbsoluteBendpoint> figureConstraintWithPath = new LinkedList<AbsoluteBendpoint>(mandatoryPoints);
            figureConstraintWithPath.add(0, new AbsoluteBendpoint((Point)defaultConstraintPoints.get(0)));
            figureConstraintWithPath.add(new AbsoluteBendpoint((Point)defaultConstraintPoints.get(defaultConstraintPoints.size() - 1)));
            self.getConnectionFigure().setRoutingConstraint(figureConstraintWithPath);
        } else {
            self.getConnectionFigure().setRoutingConstraint(defaultFigureConstraint);
        }
    }

    private static boolean isContainsBy(Point point, List<Point> points, int errorMargin) {
        int i = 0;
        while (i < points.size()) {
            if (point.getDistance(points.get(i)) < (double)errorMargin) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

