/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.parts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.forms.parts.AbstractStructuredViewerPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractStructuredViewerSection
extends AbstractSection {
    private AbstractStructuredViewerPart viewerPart;

    public AbstractStructuredViewerSection(IManagedForm form, Composite parent, int style, String[] labels) {
        this(form, parent, style, true, labels);
    }

    public AbstractStructuredViewerSection(IManagedForm form, Composite parent, int style, boolean titleBar, String[] labels) {
        super(form, parent, style, titleBar);
        this.viewerPart = this.createViewerPart(labels);
        this.viewerPart.setMinSize(50, 50);
        this.getSection().setBackground(parent.getBackground());
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected abstract AbstractStructuredViewerPart createViewerPart(String[] var1);

    protected void setViewerPart(AbstractStructuredViewerPart viewerPart) {
        this.viewerPart = viewerPart;
    }

    protected final AbstractStructuredViewerPart getViewerPart() {
        return this.viewerPart;
    }

    protected void createPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)((Object)this.viewerPart));
        this.viewerPart.createControl(parent, style, span, toolkit);
        Assert.isNotNull((Object)this.viewerPart.getViewer());
        Assert.isNotNull((Object)this.viewerPart.getViewer().getControl());
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager2) {
                AbstractStructuredViewerSection.this.fillContextMenu(manager2);
            }
        });
        manager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getViewer().getControl();
        control.setMenu(manager.createContextMenu(control));
        this.registerContextMenu(manager);
    }

    protected void registerContextMenu(MenuManager manager) {
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void onButtonSelected(Button button) {
        Assert.isNotNull((Object)button);
    }

    public void setFocus() {
        if (this.viewerPart != null) {
            this.viewerPart.getViewer().getControl().setFocus();
        }
    }
}

