/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;
import org.osgi.framework.Version;

public class InitializeLaunchConfigurations {
    private static final Set<Integer> SUPPORT_NODEJS_MAJOR_VERSIONS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(10, 11, 12, 13)));
    private static boolean alreadyWarned;

    public static String getNodeJsLocation() {
        String nodeJsLocation = System.getProperty("org.eclipse.wildwebdeveloper.nodeJSLocation");
        if (nodeJsLocation != null && Files.exists(Paths.get(nodeJsLocation, new String[0]), new LinkOption[0])) {
            InitializeLaunchConfigurations.validateNodeVersion(nodeJsLocation);
            return nodeJsLocation;
        }
        String res = InitializeLaunchConfigurations.which("node");
        if (res == null && Files.exists(Paths.get(InitializeLaunchConfigurations.getDefaultNodePath(), new String[0]), new LinkOption[0])) {
            res = InitializeLaunchConfigurations.getDefaultNodePath();
        }
        if (res != null) {
            InitializeLaunchConfigurations.validateNodeVersion(res);
            return res;
        }
        if (!alreadyWarned) {
            InitializeLaunchConfigurations.warnNodeJSMissing();
            alreadyWarned = true;
        }
        return null;
    }

    public static String which(String program) {
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "-l", "which " + program};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where " + program};
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return res;
    }

    private static String getDefaultNodePath() {
        switch (Platform.getOS()) {
            case "macosx": {
                return "/usr/local/bin/node";
            }
            case "win32": {
                return "C:\\Program Files\\nodejs\\node.exe";
            }
        }
        return "/usr/bin/node";
    }

    private static void validateNodeVersion(String nodeJsLocation) {
        String nodeVersion = null;
        String[] nodeVersionCommand = new String[]{nodeJsLocation, "-v"};
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(nodeVersionCommand).getInputStream()));){
                nodeVersion = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if (nodeVersion == null) {
            InitializeLaunchConfigurations.warnNodeJSVersionCouldNotBeDetermined();
        } else {
            Version parsedVersion = Version.parseVersion((String)(nodeVersion.startsWith("v") ? nodeVersion.replace("v", "") : nodeVersion));
            if (!SUPPORT_NODEJS_MAJOR_VERSIONS.contains(parsedVersion.getMajor())) {
                InitializeLaunchConfigurations.warnNodeJSVersionUnsupported(nodeVersion);
            }
        }
    }

    private static void warnNodeJSMissing() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environment variable contains the location to the `node` executable."));
        }
        alreadyWarned = true;
    }

    private static void warnNodeJSVersionUnsupported(String version) {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)("Node.js " + version + " is not supported"), (String)("Node.js " + version + " is not supported. This will result in editors missing key features.\n" + "Please make sure a supported version of node.js is installed and that your PATH environment variable contains the location to the `node` executable.\n" + "Supported major versions are: " + SUPPORT_NODEJS_MAJOR_VERSIONS.stream().map(String::valueOf).collect(Collectors.joining(", ")))));
        }
        alreadyWarned = true;
    }

    private static void warnNodeJSVersionCouldNotBeDetermined() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Node.js version could not be determined", (String)("Node.js version could not be determined. Please make sure a supported version of node.js is installed, editors may be missing key features otherwise.\nSupported major versions are: " + SUPPORT_NODEJS_MAJOR_VERSIONS.stream().map(String::valueOf).collect(Collectors.joining(", ")))));
        }
        alreadyWarned = true;
    }
}

