/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int maxLocals) {
        this.locals = new Type[maxLocals];
        for (int i = 0; i < maxLocals; ++i) {
            this.locals[i] = Type.UNKNOWN;
        }
    }

    protected Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        for (int i = 0; i < this.locals.length; ++i) {
            lvs.locals[i] = this.locals[i];
        }
        return lvs;
    }

    public Type get(int i) {
        return this.locals[i];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int i, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i] = type;
    }

    public int hashCode() {
        return this.locals.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i].equals(lv.locals[i])) continue;
            return false;
        }
        return true;
    }

    public void merge(LocalVariables lv) {
        if (this.locals.length != lv.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.merge(lv, i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables lv, int i) {
        try {
            if (!(this.locals[i] instanceof UninitializedObjectType) && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!this.locals[i].equals(lv.locals[i]) && this.locals[i] instanceof UninitializedObjectType && lv.locals[i] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (this.locals[i] instanceof UninitializedObjectType && !(lv.locals[i] instanceof UninitializedObjectType)) {
                this.locals[i] = ((UninitializedObjectType)this.locals[i]).getInitialized();
            }
            if (this.locals[i] instanceof ReferenceType && lv.locals[i] instanceof ReferenceType) {
                if (this.locals[i].equals(lv.locals[i])) return;
                ReferenceType sup = ((ReferenceType)this.locals[i]).getFirstCommonSuperclass((ReferenceType)lv.locals[i]);
                if (sup == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i] + "' and '" + lv.locals[i] + "'.");
                this.locals[i] = sup;
                return;
            } else {
                if (this.locals[i].equals(lv.locals[i])) return;
                this.locals[i] = Type.UNKNOWN;
            }
            return;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.locals.length; ++i) {
            sb.append(Integer.toString(i));
            sb.append(": ");
            sb.append(this.locals[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != u) continue;
            this.locals[i] = u.getInitialized();
        }
    }
}

