/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.tray.TrayAccessibleEditPart;
import org.eclipse.bpel.common.ui.tray.TrayCategoryEntryEditPartDirectEditManager;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public abstract class TrayEditPart
extends AbstractGraphicalEditPart {
    protected Adapter adapter = this.createAdapter();
    protected ILabelProvider labelProvider;
    protected DirectEditManager directEditManager;
    protected AccessibleEditPart acc;

    protected Adapter createAdapter() {
        return new Adapter(){

            public void notifyChanged(Notification notification) {
                TrayEditPart.this.refresh();
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };
    }

    public void activate() {
        super.activate();
        EObject modelObject = (EObject)this.getModel();
        modelObject.eAdapters().add((Object)this.adapter);
    }

    public void deactivate() {
        super.deactivate();
        EObject modelObject = (EObject)this.getModel();
        modelObject.eAdapters().remove((Object)this.adapter);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit((DirectEditRequest)request);
        } else {
            super.performRequest(request);
        }
    }

    protected void performDirectEdit(DirectEditRequest request) {
        if (this.getEditPolicy("DirectEditPolicy") == null) {
            return;
        }
        if (this.directEditManager == null) {
            this.directEditManager = new TrayCategoryEntryEditPartDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new CellEditorLocator(){

                public void relocate(CellEditor celleditor) {
                    Text text = (Text)celleditor.getControl();
                    Point sel = text.getSelection();
                    Point pref = text.computeSize(-1, -1);
                    Label label = TrayEditPart.this.getDirectEditLabel();
                    Rectangle rect = label.getTextBounds().getCopy();
                    label.translateToAbsolute((Translatable)rect);
                    text.setBounds(rect.x - 4, rect.y - 1, Math.min(pref.x + 1, text.getParent().getSize().x - 20), pref.y + 1);
                    text.setSelection(0);
                    text.setSelection(sel);
                }
            });
        }
        this.directEditManager.show();
    }

    public abstract Label getDirectEditLabel();

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = this.createAccessible();
        }
        return this.acc;
    }

    protected AccessibleEditPart createAccessible() {
        return new TrayAccessibleEditPart(this);
    }

    public Object getAdapter(Class key) {
        if (key == AccessibleEditPart.class) {
            return this.getAccessibleEditPart();
        }
        return super.getAdapter(key);
    }
}

