/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.toolkit.enums.CombinableLiteralProvider;
import org.eclipse.jubula.toolkit.enums.LiteralProvider;

public final class ValueSets {
    private ValueSets() {
    }

    public static enum AUTActivationMethod implements LiteralProvider
    {
        autDefault("AUT_DEFAULT"),
        none("NONE"),
        titlebar("TITLEBAR"),
        northwest("NW"),
        northeast("NE"),
        southwest("SW"),
        southeast("SE"),
        center("CENTER");

        private final String m_rcValue;

        private AUTActivationMethod(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }

        @Deprecated
        public static AUTActivationMethod literalAsEnum(String literal) {
            AUTActivationMethod[] aUTActivationMethodArray = AUTActivationMethod.values();
            int n = aUTActivationMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                AUTActivationMethod method = aUTActivationMethodArray[n2];
                if (method.rcValue().equals(literal)) {
                    return method;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum AnchorType implements LiteralProvider
    {
        incoming("incoming"),
        outgoing("outgoing"),
        both("both");

        private String m_value;

        private AnchorType(String rcValue) {
            this.m_value = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_value;
        }
    }

    public static enum BinaryChoice implements LiteralProvider
    {
        yes("yes"),
        no("no");

        private final String m_rcValue;

        private BinaryChoice(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum Direction implements LiteralProvider
    {
        up("up"),
        down("down"),
        left("left"),
        right("right");

        private final String m_rcValue;

        private Direction(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum InteractionMode implements LiteralProvider
    {
        primary(1),
        tertiary(2),
        secondary(3);

        private static Map<Integer, InteractionMode> map;
        private final Integer m_rcValue;

        static {
            map = new HashMap<Integer, InteractionMode>();
            InteractionMode[] interactionModeArray = InteractionMode.values();
            int n = interactionModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                InteractionMode mode = interactionModeArray[n2];
                map.put(mode.rcIntValue(), mode);
                ++n2;
            }
        }

        private InteractionMode(Integer rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue.toString();
        }

        public Integer rcIntValue() {
            return this.m_rcValue;
        }

        public static InteractionMode valueOf(String string) {
            return Enum.valueOf(InteractionMode.class, string);
        }
    }

    public static enum KeyStroke implements LiteralProvider
    {
        delete("DELETE");

        private final String m_rcValue;

        private KeyStroke(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum Measure implements LiteralProvider
    {
        value("value"),
        percent("percent");

        private final String m_rcValue;

        private Measure(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum Modifier implements CombinableLiteralProvider
    {
        none("none"),
        shift("shift"),
        control("control"),
        alt("alt"),
        meta("meta"),
        cmd("cmd"),
        mod("mod");

        private final String m_rcValue;

        private Modifier(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }

        @Override
        public String toString() {
            return this.rcValue();
        }

        @Deprecated
        public static Modifier[] literalAsEnum(String literal) {
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            if (literal != null) {
                String[] split;
                String[] stringArray = split = literal.split(" ");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    boolean found = false;
                    Modifier[] modifierArray = Modifier.values();
                    int n3 = modifierArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Modifier modifier = modifierArray[n4];
                        if (modifier.rcValue().equals(s)) {
                            modifiers.add(modifier);
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        throw new IllegalArgumentException("Unkown modifier: " + s);
                    }
                    ++n2;
                }
            }
            return modifiers.toArray(new Modifier[modifiers.size()]);
        }
    }

    public static enum NumberComparisonOperator implements LiteralProvider
    {
        equals("equal to"),
        greater("greater than"),
        greaterorEqual("greater or equal than"),
        less("less than"),
        lessOrEqual("less or equal than");

        private String m_value;

        private NumberComparisonOperator(String rcValue) {
            this.m_value = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_value;
        }
    }

    public static enum Operator implements LiteralProvider
    {
        equals("equals"),
        notEquals("not equals"),
        matches("matches"),
        simpleMatch("simple match");

        private final String m_rcValue;

        private Operator(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }

        @Deprecated
        public static Operator literalAsEnum(String literal) {
            Operator[] operatorArray = Operator.values();
            int n = operatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operator o = operatorArray[n2];
                if (o.rcValue().equals(literal)) {
                    return o;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum SearchType implements LiteralProvider
    {
        relative("relative"),
        absolute("absolute");

        private final String m_rcValue;

        private SearchType(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum TreeDirection implements LiteralProvider
    {
        up("up"),
        down("down"),
        next("next"),
        previous("previous");

        private final String m_rcValue;

        private TreeDirection(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }

    public static enum Unit implements LiteralProvider
    {
        pixel("pixel"),
        percent("percent");

        private final String m_rcValue;

        private Unit(String rcValue) {
            this.m_rcValue = rcValue;
        }

        @Override
        public String rcValue() {
            return this.m_rcValue;
        }
    }
}

