/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class UncontrolCommandHandler
extends AbstractHandler {
    private static final String NO_EDITING_DOMAIN_MESSAGE = Messages.getString("UncontrolCommandHandler.domain.error");
    private static final String EMPTY_SELECTION_MESSAGE = Messages.getString("UncontrolCommandHandler.selection.empty.message");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
                    NotificationBuilder.createInfoPopup((String)EMPTY_SELECTION_MESSAGE).run();
                    return null;
                }
                try {
                    TransactionalEditingDomain editingDomain = ServiceUtilsForSelection.getInstance().getTransactionalEditingDomain((Object)selection);
                    EObject eObjectToControl = EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
                    ControlModeRequest controlRequest = ControlModeRequest.createUIUncontrolModelRequest(editingDomain, eObjectToControl);
                    IControlModeManager controlMng = ControlModeManager.getInstance();
                    Diagnostic problems = controlMng.approveRequest(controlRequest);
                    if (problems != null && problems.getSeverity() >= 4) {
                        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)problems);
                        StatusManager.getManager().handle(status, 2);
                        break block6;
                    }
                    ICommand controlCommand = controlMng.getUncontrolCommand(controlRequest);
                    editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(controlCommand));
                }
                catch (ServiceException e) {
                    NotificationBuilder.createInfoPopup((String)NO_EDITING_DOMAIN_MESSAGE).run();
                }
            } else {
                NotificationBuilder.createInfoPopup((String)EMPTY_SELECTION_MESSAGE).run();
            }
        }
        return null;
    }
}

