/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StringComboBoxCellEditor
extends CellEditor {
    protected String[] items;
    private int selection;
    protected CCombo comboBox;
    private static final int defaultStyle = 0;
    private ModifyListener modifyListener;

    public StringComboBoxCellEditor() {
        this.setStyle(0);
    }

    public StringComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public StringComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public StringComboBoxCellEditor(Composite parent) {
        this(parent, new String[0]);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StringComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                StringComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StringComboBoxCellEditor.this.focusLost();
            }
        });
        this.comboBox.addModifyListener(this.getModifyListener());
        return this.comboBox;
    }

    protected Object doGetValue() {
        int curSelected = this.comboBox.getSelectionIndex();
        String strComboSelectedContent = null;
        strComboSelectedContent = curSelected != -1 ? this.comboBox.getItem(curSelected) : this.comboBox.getText();
        return strComboSelectedContent;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
            layoutData.grabHorizontal = true;
            layoutData.horizontalAlignment = 131072;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            layoutData.grabHorizontal = true;
            layoutData.horizontalAlignment = 131072;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && (value instanceof Integer || value instanceof String) ? 1 : 0) != 0);
        this.comboBox.setText((String)value);
    }

    private void populateComboBoxItems() {
        int num = 0;
        if (this.comboBox != null && this.items != null) {
            num = this.comboBox.getItemCount();
            this.comboBox.remove(0, num - 1);
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    private void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringComboBoxCellEditor.this.fireEditorValueChanged(true, true);
                }
            };
        }
        return this.modifyListener;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

