/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.branch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchManagerImpl;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointRangeImpl;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public final class CDOBranchUtil {
    private static final char PATH_SEPARATOR_CHAR = "/".charAt(0);
    public static final CDOBranchPoint AUTO_BRANCH_POINT = new AutoBranchPoint();

    private CDOBranchUtil() {
    }

    public static InternalCDOBranchManager createBranchManager() {
        return new CDOBranchManagerImpl();
    }

    public static CDOBranchPointRange createRange(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        return new CDOBranchPointRangeImpl(startPoint, endPoint);
    }

    public static void writeRange(CDODataOutput out, CDOBranchPointRange range) throws IOException {
        out.writeCDOBranchPoint(range.getStartPoint());
        out.writeCDOBranchPoint(range.getEndPoint());
    }

    public static CDOBranchPointRange readRange(CDODataInput in) throws IOException {
        CDOBranchPoint startPoint = in.readCDOBranchPoint();
        CDOBranchPoint endPoint = in.readCDOBranchPoint();
        return CDOBranchUtil.createRange(startPoint, endPoint);
    }

    public static void writeRangeOrNull(CDODataOutput out, CDOBranchPointRange range) throws IOException {
        if (range != null) {
            out.writeBoolean(true);
            CDOBranchUtil.writeRange(out, range);
        } else {
            out.writeBoolean(false);
        }
    }

    public static CDOBranchPointRange readRangeOrNull(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            return CDOBranchUtil.readRange(in);
        }
        return null;
    }

    public static void writeBranchPointOrNull(CDODataOutput out, CDOBranchPoint point) throws IOException {
        if (point != null) {
            out.writeBoolean(true);
            out.writeCDOBranchPoint(point);
        } else {
            out.writeBoolean(false);
        }
    }

    public static CDOBranchPoint readBranchPointOrNull(CDODataInput in) throws IOException {
        if (in.readBoolean()) {
            return in.readCDOBranchPoint();
        }
        return null;
    }

    public static CDOBranchPoint copyBranchPoint(CDOBranchPoint source) {
        return source.getBranch().getPoint(source.getTimeStamp());
    }

    public static CDOBranchVersion copyBranchVersion(CDOBranchVersion source) {
        return source.getBranch().getVersion(source.getVersion());
    }

    public static CDOBranchPoint adjustBranchPoint(CDOBranchPoint branchPoint, CDOBranchManager branchManager) {
        CDOBranch branch = branchPoint.getBranch();
        if (branch.getBranchManager() != branchManager) {
            branch = branchManager.getBranch(branch.getID());
            branchPoint = branch.getPoint(branchPoint.getTimeStamp());
        }
        return branchPoint;
    }

    public static CDOBranchPoint normalizeBranchPoint(CDOBranchPoint branchPoint) {
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp == 0L) {
            return branchPoint;
        }
        CDOBranch branch = branchPoint.getBranch();
        return CDOBranchUtil.doNormalizeBranchPoint(branch, timeStamp);
    }

    public static CDOBranchPoint normalizeBranchPoint(CDOBranch branch, long timeStamp) {
        if (timeStamp == 0L) {
            return branch.getHead();
        }
        return CDOBranchUtil.doNormalizeBranchPoint(branch, timeStamp);
    }

    private static CDOBranchPoint doNormalizeBranchPoint(CDOBranch branch, long timeStamp) {
        long baseTime;
        while (timeStamp < (baseTime = branch.getBase().getTimeStamp())) {
            if ((branch = branch.getBase().getBranch()) != null) continue;
            throw new IllegalArgumentException("Time " + CDOCommonUtil.formatTimeStamp(timeStamp) + " is before the repository creation time " + CDOCommonUtil.formatTimeStamp(baseTime));
        }
        return branch.getPoint(timeStamp);
    }

    public static boolean isContainedBy(CDOBranchPoint contained, CDOBranchPoint container) {
        CDOBranch containerBranch = container.getBranch();
        if (containerBranch == contained.getBranch()) {
            return CDOCommonUtil.compareTimeStamps(contained.getTimeStamp(), container.getTimeStamp()) <= 0;
        }
        if (containerBranch == null) {
            return false;
        }
        return CDOBranchUtil.isContainedBy(contained, containerBranch.getBase());
    }

    public static CDOBranchPoint getAncestor(CDOBranchPoint point1, CDOBranchPoint point2) {
        if (point1.getBranch() == null) {
            return point1;
        }
        if (point2.getBranch() == null) {
            return point2;
        }
        CDOBranchPoint[] path1 = CDOBranchUtil.getPath(point1);
        CDOBranchPoint[] path2 = CDOBranchUtil.getPath(point2);
        CDOBranchPoint[] cDOBranchPointArray = path1;
        int n = path1.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranchPoint pathPoint1 = cDOBranchPointArray[n2];
            CDOBranchPoint[] cDOBranchPointArray2 = path2;
            int n3 = path2.length;
            int n4 = 0;
            while (n4 < n3) {
                CDOBranchPoint pathPoint2 = cDOBranchPointArray2[n4];
                if (pathPoint1.getBranch() == pathPoint2.getBranch()) {
                    if (CDOCommonUtil.compareTimeStamps(pathPoint1.getTimeStamp(), pathPoint2.getTimeStamp()) < 0) {
                        return pathPoint1;
                    }
                    return pathPoint2;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static CDOBranchPoint[] getPath(CDOBranchPoint point) {
        ArrayList<CDOBranchPoint> result = new ArrayList<CDOBranchPoint>();
        CDOBranchUtil.getPath(point, result);
        return result.toArray(new CDOBranchPoint[result.size()]);
    }

    private static void getPath(CDOBranchPoint point, List<CDOBranchPoint> result) {
        CDOBranch branch = point.getBranch();
        if (branch != null) {
            result.add(point);
            CDOBranchUtil.getPath(branch.getBase(), result);
        }
    }

    public static String sanitizePathName(String pathName) {
        pathName = pathName.trim();
        int length = pathName.length();
        int i = 0;
        while (i < length && pathName.charAt(i) == PATH_SEPARATOR_CHAR) {
            ++i;
        }
        return i == 0 ? pathName : pathName.substring(i);
    }

    private static final class AutoBranchPoint
    implements CDOBranchPoint {
        private AutoBranchPoint() {
        }

        @Override
        public long getTimeStamp() {
            return Long.MIN_VALUE;
        }

        @Override
        public CDOBranch getBranch() {
            return null;
        }

        public String toString() {
            return "BranchPoint[AUTO]";
        }
    }
}

