/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.m2e.pde.ui.editor.ClipboardParser;
import org.eclipse.m2e.pde.ui.editor.MavenArtifactInstructionsWizard;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.ui.target.ITargetLocationWizard;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class MavenTargetLocationWizard
extends Wizard
implements ITargetLocationWizard {
    private Text artifactId;
    private Text groupId;
    private Text version;
    private Text classifier;
    private CCombo type;
    private MavenTargetLocation targetLocation;
    private CCombo scope;
    private ComboViewer metadata;
    private ITargetDefinition targetDefinition;
    private BNDInstructions bndInstructions;
    private Button includeSource;

    public MavenTargetLocationWizard() {
        this(null);
    }

    public MavenTargetLocationWizard(final MavenTargetLocation targetLocation) {
        this.targetLocation = targetLocation;
        this.setWindowTitle(Messages.MavenTargetLocationWizard_0);
        WizardPage page = new WizardPage(targetLocation == null ? Messages.MavenTargetLocationWizard_1 : Messages.MavenTargetLocationWizard_2){
            private Link editInstructionsButton;
            private Label scopeLabel;

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.setControl((Control)composite);
                composite.setLayout((Layout)new GridLayout(2, false));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_3);
                MavenTargetLocationWizard.this.groupId = this.fill(new Text(composite, 2048));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_4);
                MavenTargetLocationWizard.this.artifactId = this.fill(new Text(composite, 2048));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_5);
                MavenTargetLocationWizard.this.version = this.fill(new Text(composite, 2048));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_7);
                MavenTargetLocationWizard.this.classifier = this.fill(new Text(composite, 2048));
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_6);
                MavenTargetLocationWizard.this.type = this.combo(new CCombo(composite, 2048));
                MavenTargetLocationWizard.this.type.add("jar");
                MavenTargetLocationWizard.this.type.add("bundle");
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_9);
                this.createMetadataCombo(composite);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_10);
                this.createScopeCombo(composite);
                new Label(composite, 0).setText(Messages.MavenTargetLocationWizard_8);
                MavenTargetLocationWizard.this.includeSource = new Button(composite, 32);
                if (targetLocation != null) {
                    MavenTargetLocationWizard.this.artifactId.setText(targetLocation.getArtifactId());
                    MavenTargetLocationWizard.this.groupId.setText(targetLocation.getGroupId());
                    MavenTargetLocationWizard.this.version.setText(targetLocation.getVersion());
                    MavenTargetLocationWizard.this.classifier.setText(targetLocation.getClassifier());
                    MavenTargetLocationWizard.this.type.setText(targetLocation.getArtifactType());
                    MavenTargetLocationWizard.this.scope.setText(targetLocation.getDependencyScope());
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)targetLocation.getMetadataMode()));
                    MavenTargetLocationWizard.this.bndInstructions = targetLocation.getInstructions(null);
                    MavenTargetLocationWizard.this.includeSource.setSelection(targetLocation.isIncludeSource());
                } else {
                    Clipboard clipboard = new Clipboard(composite.getDisplay());
                    String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    clipboard.dispose();
                    ClipboardParser clipboardParser = new ClipboardParser(text);
                    MavenTargetLocationWizard.this.groupId.setText(clipboardParser.getGroupId());
                    MavenTargetLocationWizard.this.artifactId.setText(clipboardParser.getArtifactId());
                    MavenTargetLocationWizard.this.version.setText(clipboardParser.getVersion());
                    MavenTargetLocationWizard.this.classifier.setText(clipboardParser.getClassifier());
                    MavenTargetLocationWizard.this.type.setText("jar");
                    MavenTargetLocationWizard.this.scope.setText(clipboardParser.getScope());
                    MavenTargetLocationWizard.this.metadata.setSelection((ISelection)new StructuredSelection((Object)MavenTargetLocation.DEFAULT_METADATA_MODE));
                    MavenTargetLocationWizard.this.bndInstructions = new BNDInstructions("", null);
                    MavenTargetLocationWizard.this.includeSource.setSelection(true);
                    Exception clipboardError = clipboardParser.getError();
                    if (clipboardError != null) {
                        Platform.getLog(MavenTargetLocationWizard.class).warn(MessageFormat.format(Messages.MavenTargetLocationWizard_11, clipboardError.getMessage()));
                    }
                }
                this.updateUI();
            }

            private void createScopeCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 20;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                MavenTargetLocationWizard.this.scope = this.combo(new CCombo(composite, 2048));
                this.scopeLabel = new Label(composite, 0);
                this.scopeLabel.setText(Messages.MavenTargetLocationWizard_15);
                MavenTargetLocationWizard.this.scope.add("");
                MavenTargetLocationWizard.this.scope.add("compile");
                MavenTargetLocationWizard.this.scope.add("test");
                MavenTargetLocationWizard.this.scope.add("provided");
                MavenTargetLocationWizard.this.scope.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.updateUI();
                    }
                });
            }

            private void createMetadataCombo(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 20;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                composite.setLayout((Layout)layout);
                MavenTargetLocationWizard.this.metadata = new ComboViewer(this.combo(new CCombo(composite, 2056)));
                MavenTargetLocationWizard.this.metadata.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                MavenTargetLocationWizard.this.metadata.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof MissingMetadataMode) {
                            return ((MissingMetadataMode)element).name().toLowerCase();
                        }
                        return super.getText(element);
                    }
                });
                this.editInstructionsButton = new Link(composite, 8);
                this.editInstructionsButton.setText(Messages.MavenTargetLocationWizard_20);
                this.editInstructionsButton.setToolTipText(Messages.MavenTargetLocationWizard_21);
                this.editInstructionsButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        BNDInstructions edited = MavenArtifactInstructionsWizard.openWizard(this.getShell(), Objects.requireNonNullElse((this).MavenTargetLocationWizard.this.bndInstructions, BNDInstructions.EMPTY));
                        if (edited != null) {
                            (this).MavenTargetLocationWizard.this.bndInstructions = edited;
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                MavenTargetLocationWizard.this.metadata.setInput((Object)MissingMetadataMode.values());
                MavenTargetLocationWizard.this.metadata.addSelectionChangedListener(e -> this.updateUI());
            }

            private void updateUI() {
                this.editInstructionsButton.setVisible(MavenTargetLocationWizard.this.metadata.getStructuredSelection().getFirstElement() == MissingMetadataMode.GENERATE);
                this.scopeLabel.setVisible(MavenTargetLocationWizard.this.scope.getText().isBlank());
            }

            private Text fill(Text text) {
                GridData data = new GridData(768);
                data.grabExcessHorizontalSpace = true;
                text.setLayoutData((Object)data);
                return text;
            }

            private CCombo combo(CCombo combo) {
                GridData data = new GridData();
                data.widthHint = 100;
                combo.setLayoutData((Object)data);
                return combo;
            }
        };
        page.setImageDescriptor(ImageDescriptor.createFromURL((URL)MavenTargetLocationWizard.class.getResource("/icons/new_m2_project_wizard.gif")));
        page.setTitle(page.getName());
        page.setDescription(Messages.MavenTargetLocationWizard_23);
        this.addPage((IWizardPage)page);
    }

    public void setTarget(ITargetDefinition target) {
        this.targetDefinition = target;
    }

    public ITargetLocation[] getLocations() {
        return new ITargetLocation[]{this.targetLocation};
    }

    public boolean performFinish() {
        List<Object> list = this.bndInstructions == null ? Collections.emptyList() : Collections.singletonList(this.bndInstructions);
        MavenTargetLocation location = new MavenTargetLocation(this.groupId.getText(), this.artifactId.getText(), this.version.getText(), this.type.getText(), this.classifier.getText(), (MissingMetadataMode)this.metadata.getStructuredSelection().getFirstElement(), this.scope.getText(), list, this.includeSource.getSelection());
        if (this.targetLocation == null) {
            this.targetLocation = location;
        } else {
            ITargetLocation[] locations = (ITargetLocation[])this.targetDefinition.getTargetLocations().clone();
            int i = 0;
            while (i < locations.length) {
                if (locations[i] == this.targetLocation) {
                    locations[i] = location;
                }
                ++i;
            }
            this.targetDefinition.setTargetLocations(locations);
        }
        return true;
    }
}

