/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;

public class HttpServer {
    private Server server;
    private int httpPort;
    private int httpsPort = -1;
    private String keyStoreLocation = "resources/ssl/keystore";
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private boolean needClientAuth;
    private String proxyUsername;
    private String proxyPassword;
    private boolean redirectToHttps;
    private long latency;
    private Map<String, String> userPasswords = new HashMap<String, String>();
    private Map<String, String[]> userRoles = new HashMap<String, String[]>();
    private Map<String, String[]> securedRealms = new HashMap<String, String[]>();
    private Map<String, File> resourceDirs = new TreeMap(Collections.reverseOrder());
    private Map<String, String[]> resourceFilters = new HashMap<String, String[]>();
    private Map<String, String> filterTokens = new HashMap<String, String>();
    private Collection<String> recordedPatterns = new HashSet<String>();
    private List<String> recordedRequests = new ArrayList<String>();
    private Map<String, Map<String, String>> recordedHeaders = new HashMap<String, Map<String, String>>();
    private String storePassword;

    protected Connector newHttpConnector() {
        HttpConfiguration config = new HttpConfiguration();
        config.setSecurePort(this.httpsPort);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setPort(this.httpPort);
        return connector;
    }

    protected Connector newHttpsConnector() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyManagerPassword(this.storePassword);
        sslContextFactory.setKeyStorePath(new File(this.keyStoreLocation).getAbsolutePath());
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        if (this.trustStoreLocation != null && !this.trustStoreLocation.equals("")) {
            sslContextFactory.setTrustStorePath(new File(this.trustStoreLocation).getAbsolutePath());
        }
        if (this.trustStorePassword != null && !this.trustStoreLocation.equals("")) {
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        sslContextFactory.setNeedClientAuth(this.needClientAuth);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString())});
        connector.setPort(this.httpsPort);
        return connector;
    }

    public HttpServer setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public int getHttpPort() {
        if (this.httpPort >= 0 && this.server != null && this.server.isRunning()) {
            return ((NetworkConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        return this.httpPort;
    }

    public String getHttpUrl() {
        return "http://localhost:" + this.getHttpPort();
    }

    public HttpServer setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public int getHttpsPort() {
        if (this.httpsPort >= 0 && this.server != null && this.server.isRunning()) {
            return ((NetworkConnector)this.server.getConnectors()[this.httpPort < 0 ? 0 : 1]).getLocalPort();
        }
        return this.httpsPort;
    }

    public String getHttpsUrl() {
        return "https://localhost:" + this.getHttpsPort();
    }

    public HttpServer setKeyStore(String path, String password) {
        this.keyStoreLocation = path;
        this.keyStorePassword = password;
        if (this.storePassword == null) {
            this.storePassword = this.keyStorePassword;
        }
        return this;
    }

    public HttpServer setTrustStore(String path, String password) {
        this.trustStoreLocation = path;
        this.trustStorePassword = password;
        return this;
    }

    public HttpServer setStorePassword(String password) {
        this.storePassword = password;
        return this;
    }

    public HttpServer setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public HttpServer setProxyAuth(String username, String password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        return this;
    }

    protected Handler newProxyHandler() {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                String auth = request.getHeader("Proxy-Authorization");
                if (auth != null) {
                    auth = auth.substring(auth.indexOf(32) + 1).trim();
                    auth = new String(Base64.getDecoder().decode(auth));
                }
            }
        };
    }

    public HttpServer setRedirectToHttps(boolean redirectToHttps) {
        this.redirectToHttps = redirectToHttps;
        return this;
    }

    protected Handler newSslRedirectHandler() {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                int httpsPort = HttpServer.this.getHttpsPort();
                if (!((Request)request).isHandled() && request.getServerPort() != httpsPort) {
                    String url = "https://" + request.getServerName() + ":" + httpsPort + request.getRequestURI();
                    response.setStatus(301);
                    response.setHeader("Location", url);
                    ((Request)request).setHandled(true);
                }
            }
        };
    }

    public HttpServer addUser(String username, String password, String ... roles) {
        this.userPasswords.put(username, password);
        this.userRoles.put(username, roles == null ? new String[]{} : roles);
        return this;
    }

    public HttpServer addSecuredRealm(String pathSpec, String ... roles) {
        this.securedRealms.put(pathSpec, roles == null ? new String[]{} : roles);
        return this;
    }

    protected SecurityHandler newSecurityHandler() {
        String password22;
        Object roles;
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        for (String pathSpec : this.securedRealms.keySet()) {
            roles = this.securedRealms.get(pathSpec);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setRoles((String[])roles);
            constraint.setAuthenticate(true);
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint);
            constraintMapping.setPathSpec(pathSpec);
            mappings.add(constraintMapping);
        }
        Properties p = new Properties();
        for (String username : this.userPasswords.keySet()) {
            password22 = this.userPasswords.get(username);
            String[] roles2 = this.userRoles.get(username);
            StringBuilder entry = new StringBuilder(password22);
            String[] stringArray = roles2;
            int n = roles2.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                entry.append(",");
                entry.append(role);
                ++n2;
            }
            p.put(username, entry.toString());
        }
        File propFile = new File("target/users.properties");
        try {
            roles = null;
            password22 = null;
            try (FileOutputStream in = new FileOutputStream(propFile);){
                p.store(in, null);
            }
            catch (Throwable password22) {
                if (roles == null) {
                    roles = password22;
                } else if (roles != password22) {
                    ((Throwable)roles).addSuppressed(password22);
                }
                throw roles;
            }
        }
        catch (IOException ex) {
            Assert.fail((String)"Unable to create users properties file");
        }
        HashLoginService userRealm = new HashLoginService("TestRealm", "target/users.properties");
        this.server.addBean((Object)userRealm);
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setLoginService((LoginService)userRealm);
        securityHandler.setConstraintMappings(mappings);
        return securityHandler;
    }

    public HttpServer addResources(String contextRoot, String baseDirectory, String ... filteredExtensions) {
        contextRoot = HttpServer.normalizeContextRoot(contextRoot);
        File basedir = new File(baseDirectory).getAbsoluteFile();
        this.resourceDirs.put(contextRoot, basedir);
        this.resourceFilters.put(contextRoot, filteredExtensions == null ? new String[]{} : filteredExtensions);
        return this;
    }

    public HttpServer enableRecording(String ... patterns) {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.recordedPatterns.add(pattern);
            ++n2;
        }
        return this;
    }

    public List<String> getRecordedRequests() {
        return this.recordedRequests;
    }

    public Map<String, String> getRecordedHeaders(String uri) {
        return this.recordedHeaders.get(uri);
    }

    public HttpServer setFilterToken(String token, String value) {
        if (value == null) {
            this.filterTokens.remove(token);
        } else {
            this.filterTokens.put(token, value);
        }
        return this;
    }

    protected Handler newResourceHandler() {
        return new ResHandler();
    }

    public HttpServer setLatency(long millis) {
        this.latency = millis;
        return this;
    }

    protected Handler newSleepHandler(final long millis) {
        return new AbstractHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                if (millis >= 0L) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    3 var5_6 = this;
                    synchronized (var5_6) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
    }

    public HttpServer start() throws Exception {
        if (this.server != null) {
            return this;
        }
        this.recordedRequests.clear();
        this.server = new Server();
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        if (this.httpPort >= 0) {
            connectors.add(this.newHttpConnector());
        }
        if (this.httpsPort >= 0 && this.keyStoreLocation != null) {
            connectors.add(this.newHttpsConnector());
        }
        HandlerList handlerList = new HandlerList();
        if (!this.recordedPatterns.isEmpty()) {
            handlerList.addHandler((Handler)new RecordingHandler());
        }
        if (this.latency != 0L) {
            handlerList.addHandler(this.newSleepHandler(this.latency));
        }
        if (this.redirectToHttps) {
            handlerList.addHandler(this.newSslRedirectHandler());
        }
        if (this.proxyUsername != null && this.proxyPassword != null) {
            handlerList.addHandler(this.newProxyHandler());
        }
        SecurityHandler security = null;
        if (!this.securedRealms.isEmpty()) {
            security = this.newSecurityHandler();
            handlerList.addHandler((Handler)security);
        }
        if (!this.resourceDirs.isEmpty()) {
            if (security != null) {
                security.setHandler(this.newResourceHandler());
            } else {
                handlerList.addHandler(this.newResourceHandler());
            }
        }
        handlerList.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlerList);
        this.server.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        this.server.start();
        this.waitForConnectors();
        this.addDefaultFilterTokens();
        return this;
    }

    protected void waitForConnectors() throws Exception {
        ArrayList<Connector> badConnectors = new ArrayList<Connector>(2);
        int r = 10;
        while (r > 0) {
            int i = 200;
            while (i > 0) {
                badConnectors.clear();
                Connector[] connectorArray = this.server.getConnectors();
                int n = connectorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Connector connector = connectorArray[n2];
                    if (((NetworkConnector)connector).getLocalPort() < 0) {
                        badConnectors.add(connector);
                    }
                    ++n2;
                }
                if (badConnectors.isEmpty()) {
                    return;
                }
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException e) {
                    return;
                }
                --i;
            }
            System.err.println("WARNING: " + badConnectors + " did not start properly, restarting");
            for (Connector connector : badConnectors) {
                connector.stop();
                connector.start();
            }
            --r;
        }
    }

    protected void addDefaultFilterTokens() {
        if (!this.filterTokens.containsKey("@basedir@")) {
            this.filterTokens.put("@basedir@", new File("").getAbsolutePath());
        }
        if (!this.filterTokens.containsKey("@baseurl@")) {
            String baseurl = "file://" + new File("").toURI().getPath();
            if (baseurl.endsWith("/")) {
                baseurl = baseurl.substring(0, baseurl.length() - 1);
            }
            this.filterTokens.put("@baseurl@", baseurl);
        }
        if (!this.filterTokens.containsKey("@baseuri@")) {
            String baseuri = "file://" + new File("").toURI().getRawPath();
            if (baseuri.endsWith("/")) {
                baseuri = baseuri.substring(0, baseuri.length() - 1);
            }
            this.filterTokens.put("@baseuri@", baseuri);
        }
        if (!this.filterTokens.containsKey("@port.http@")) {
            this.filterTokens.put("@port.http@", Integer.toString(this.getHttpPort()));
        }
        if (!this.filterTokens.containsKey("@port.https@")) {
            this.filterTokens.put("@port.https@", Integer.toString(this.getHttpsPort()));
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.server = null;
        }
    }

    private static String normalizeContextRoot(String contextRoot) {
        if (contextRoot.endsWith("/")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return contextRoot;
    }

    private static String trimContextRoot(String uri, String contextRoot) {
        if (uri.startsWith(contextRoot)) {
            if (contextRoot.length() == 1) {
                return uri.substring(1);
            }
            if (uri.length() > contextRoot.length() && uri.charAt(contextRoot.length()) == '/') {
                return uri.substring(contextRoot.length() + 1);
            }
        }
        return null;
    }

    public void resetRecording() {
        this.recordedHeaders.clear();
        this.recordedRequests.clear();
    }

    class RecordingHandler
    extends AbstractHandler {
        RecordingHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            String uri = request.getRequestURI();
            for (String pattern : HttpServer.this.recordedPatterns) {
                if (!uri.matches(pattern)) continue;
                String req = String.valueOf(request.getMethod()) + " " + uri;
                HttpServer.this.recordedRequests.add(req);
                HashMap<String, String> headers = new HashMap<String, String>();
                HttpServer.this.recordedHeaders.put(uri, headers);
                Enumeration h = request.getHeaderNames();
                while (h.hasMoreElements()) {
                    String headername = (String)h.nextElement();
                    headers.put(headername, request.getHeader(headername));
                }
            }
        }
    }

    class ResHandler
    extends AbstractHandler {
        ResHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            String uri = request.getRequestURI();
            for (String contextRoot : HttpServer.this.resourceDirs.keySet()) {
                String path = URIUtil.decodePath((String)HttpServer.trimContextRoot(uri, contextRoot));
                if (path == null) continue;
                File basedir = HttpServer.this.resourceDirs.get(contextRoot);
                File file = new File(basedir, path);
                if (HttpMethod.HEAD.equals((Object)request.getMethod())) {
                    if (file.exists()) {
                        response.setStatus(200);
                    } else {
                        response.setStatus(404);
                    }
                    ((Request)request).setHandled(true);
                    return;
                }
                if (HttpMethod.PUT.equals((Object)request.getMethod()) || HttpMethod.POST.equals((Object)request.getMethod())) {
                    file.getParentFile().mkdirs();
                    try (FileOutputStream os = new FileOutputStream(file);){
                        IO.copy((InputStream)request.getInputStream(), (OutputStream)os);
                    }
                    response.setStatus(201);
                    ((Request)request).setHandled(true);
                    break;
                }
                if (!file.isFile()) break;
                try (FileInputStream is = new FileInputStream(file);){
                    String filterEncoding = this.getFilterEncoding(path, HttpServer.this.resourceFilters.get(contextRoot));
                    if (filterEncoding == null) {
                        IO.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    } else {
                        String text = IO.toString((InputStream)is, (String)filterEncoding);
                        text = this.filter(text, HttpServer.this.filterTokens);
                        response.getOutputStream().write(text.getBytes(filterEncoding));
                    }
                }
                response.setStatus(200);
                ((Request)request).setHandled(true);
                break;
            }
        }

        private String getExtension(String path) {
            return path.substring(path.lastIndexOf(46) + 1);
        }

        private String getFilterEncoding(String path, String[] filteredExtensions) {
            String ext = this.getExtension(path);
            if (filteredExtensions != null) {
                String[] stringArray = filteredExtensions;
                int n = filteredExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String filteredExtension = stringArray[n2];
                    if (filteredExtension.startsWith(".")) {
                        filteredExtension = filteredExtension.substring(1);
                    }
                    if (filteredExtension.equalsIgnoreCase(ext)) {
                        return "properties".equalsIgnoreCase(ext) ? "ISO-8859-1" : "UTF-8";
                    }
                    ++n2;
                }
            }
            return null;
        }

        private String filter(String str, Map<String, String> tokens) {
            for (String token : tokens.keySet()) {
                str = str.replace(token, tokens.get(token));
            }
            return str;
        }
    }
}

