/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.ArrayList;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@Icon(value="/META-INF/icons/compare.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/comparingdata.html")
public class SimpleComparison
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.SECONDARY_SNAPSHOT)
    public ISnapshot baseline;
    @Argument
    public String query;
    @Argument(isMandatory=false)
    public String options;
    @Argument(isMandatory=false)
    public String defaultoptions = "-mask \"\\s@ 0x[0-9a-f]+|^(\\[[0-9]+\\], )*\\[[0-9]+\\]$|(?<=\\p{javaJavaIdentifierPart}\\[)\\d+(?=\\])\" -x java.util.HashMap$Node:key java.util.Hashtable$Entry:key java.util.WeakHashMap$Entry:referent java.util.concurrent.ConcurrentHashMap$Node:key";
    @Argument(isMandatory=false)
    public Retained retained;

    public IResult execute(IProgressListener listener) throws Exception {
        IStructuredResult baseTable = this.callQuery(listener, this.baseline);
        IStructuredResult currTable = this.callQuery(listener, this.snapshot);
        String queryId = "comparetablesquery";
        if (this.options != null && this.options.length() > 0) {
            queryId = String.valueOf(queryId) + " " + this.options;
        }
        if (this.defaultoptions != null && this.defaultoptions.length() > 0) {
            queryId = String.valueOf(queryId) + " " + this.defaultoptions;
        }
        SnapshotQuery queryc = SnapshotQuery.parse(queryId, this.snapshot);
        ArrayList<IStructuredResult> r = new ArrayList<IStructuredResult>();
        r.add(baseTable);
        r.add(currTable);
        queryc.setArgument("tables", r);
        ArrayList<ISnapshot> snapshots = new ArrayList<ISnapshot>();
        snapshots.add(this.baseline);
        snapshots.add(this.snapshot);
        queryc.setArgument("snapshots", snapshots);
        IResult ret = queryc.execute(listener);
        listener.done();
        return ret;
    }

    private IStructuredResult callQuery(IProgressListener listener, ISnapshot snapshot) throws Exception {
        if (this.retained != null) {
            RefinedResultBuilder rb1 = SnapshotQuery.parse(this.query, snapshot).refine(listener);
            rb1.setInlineRetainedSizeCalculation(true);
            rb1.addDefaultContextDerivedColumn(this.retained == Retained.PRECISE ? RetainedSizeDerivedData.PRECISE : RetainedSizeDerivedData.APPROXIMATE);
            return rb1.build();
        }
        return (IStructuredResult)SnapshotQuery.parse(this.query, snapshot).execute(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Retained {
        APPROXIMATE,
        PRECISE;

    }
}

