/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.inspections.collections.AbstractFillRatioQuery;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="collection_fill_ratio")
@Icon(value="/META-INF/icons/collection_fill.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractCollection", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.concurrent.CopyOnWriteArrayList", "java.util.Collections$SynchronizedCollection", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableCollection", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedCollection", "java.util.Collections$CheckedMap", "java.util.Collections$CheckedMap$CheckedEntrySet", "java.util.Collections$SetFromMap", "java.util.Properties$EntrySet", "java.util.ResourceBundle", "java.awt.RenderingHints", "java.beans.beancontext.BeanContextSupport", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure", "java.util.AbstractMap", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedMap", "java.util.Collections$SetFromMap", "java.util.ResourceBundle", "java.beans.beancontext.BeanContextSupport", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure"})
public class CollectionFillRatioQuery
extends AbstractFillRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;
    @Argument(isMandatory=false)
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        FieldSizeArrayCollectionExtractor specificExtractor;
        listener.subTask(Messages.CollectionFillRatioQuery_ExtractingFillRatios);
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.CollectionFillRatioQuery_Column_FillRatio, (double)0.0, (double)5.0, (double)(1.0 / (double)this.segments));
        builder.column(Messages.CollectionFillRatioQuery_ColumnNumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        if (this.size_attribute != null && this.array_attribute != null) {
            specificExtractor = new FieldSizeArrayCollectionExtractor(this.size_attribute, this.array_attribute);
        } else if (this.size_attribute == null && this.array_attribute == null) {
            specificExtractor = null;
        } else {
            throw new IllegalArgumentException(Messages.CollectionFillRatioQuery_NeedSizeAndArrayOrNone);
        }
        this.runQuantizer(listener, quantize, specificExtractor, this.collection, this.snapshot, this.objects);
        return quantize.getResult();
    }
}

