/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.mat.hprof.CompressedRandomAccessFile;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;

public class BufferingRafPositionInputStream
implements IPositionInputStream,
Closeable,
AutoCloseable {
    private final RandomAccessFile raf;
    private long channelPosition = 0L;
    private byte[] buffer;
    private byte[] throwaway;
    private final int readLength;
    private int bufferPosition = 0;
    private int bufferLength = 0;

    public BufferingRafPositionInputStream(File file, long offset, int readLength, long estlen) throws IOException {
        RandomAccessFile raf1 = new RandomAccessFile(file, "r");
        boolean gzip = CompressedRandomAccessFile.isGZIP(raf1);
        if (gzip) {
            raf1.close();
            this.raf = new CompressedRandomAccessFile(file, false, estlen);
        } else {
            this.raf = raf1;
        }
        this.readLength = readLength;
        this.buffer = new byte[readLength * 2];
        this.throwaway = new byte[readLength * 2];
        this.seek(offset);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public int read() throws IOException {
        if (!this.ensureAvailable(1)) {
            return -1;
        }
        return 0xFF & this.buffer[this.bufferPosition++];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        copied = 0;
        ** GOTO lbl17
        {
            this.bufferPosition = 0;
            this.bufferLength = 0;
            read = this.raf.read(this.buffer, 0, this.readLength);
            if (read <= 0) {
                return copied > 0 ? copied : -1;
            }
            this.bufferLength = read;
            this.channelPosition += (long)this.bufferLength;
            do {
                if (this.bufferPosition == this.bufferLength) continue block0;
                toCopy = Math.min(len - copied, this.bufferLength - this.bufferPosition);
                System.arraycopy(this.buffer, this.bufferPosition, b, off, toCopy);
                this.bufferPosition += toCopy;
                off += toCopy;
                copied += toCopy;
lbl17:
                // 2 sources

            } while (copied < len);
        }
        return copied;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if ((long)(this.bufferLength - this.bufferPosition) >= n) {
            this.bufferPosition = (int)((long)this.bufferPosition + n);
            return n;
        }
        if (n > (long)this.readLength) {
            this.seek(this.position() + n);
            return n;
        }
        long sk = 0L;
        while (n > sk) {
            int rd = this.read(this.throwaway, 0, (int)Math.min((long)this.throwaway.length, n - sk));
            if (rd <= 0) break;
            sk += (long)rd;
        }
        return sk;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_mark);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException(Messages.IPositionInputStream_reset);
    }

    @Override
    public int skipBytes(long n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        int r = this.read(b, 0, b.length);
        if (r < b.length) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int r = this.read(b, off, len);
        if (r < len) {
            throw new EOFException();
        }
    }

    @Override
    public long position() {
        return this.channelPosition - (long)(this.bufferLength - this.bufferPosition);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    private boolean ensureAvailable(int required) throws IOException {
        while (this.bufferLength - this.bufferPosition < required) {
            int toKeep = this.bufferLength - this.bufferPosition;
            System.arraycopy(this.buffer, this.bufferPosition, this.buffer, 0, toKeep);
            this.bufferPosition = 0;
            this.bufferLength = toKeep;
            int amountRead = this.raf.read(this.buffer, this.bufferLength, this.readLength - this.bufferLength);
            if (amountRead <= 0) break;
            this.bufferLength += amountRead;
            this.channelPosition += (long)amountRead;
        }
        return this.bufferLength - this.bufferPosition >= required;
    }

    @Override
    public int readInt() throws IOException {
        if (!this.ensureAvailable(4)) {
            throw new EOFException();
        }
        int ch1 = this.buffer[this.bufferPosition] & 0xFF;
        int ch2 = this.buffer[this.bufferPosition + 1] & 0xFF;
        int ch3 = this.buffer[this.bufferPosition + 2] & 0xFF;
        int ch4 = this.buffer[this.bufferPosition + 3] & 0xFF;
        int result = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        this.bufferPosition += 4;
        return result;
    }

    @Override
    public long readLong() throws IOException {
        if (!this.ensureAvailable(8)) {
            throw new EOFException();
        }
        long result = ((long)this.buffer[this.bufferPosition] << 56) + ((long)(this.buffer[this.bufferPosition + 1] & 0xFF) << 48) + ((long)(this.buffer[this.bufferPosition + 2] & 0xFF) << 40) + ((long)(this.buffer[this.bufferPosition + 3] & 0xFF) << 32) + ((long)(this.buffer[this.bufferPosition + 4] & 0xFF) << 24) + (long)((this.buffer[this.bufferPosition + 5] & 0xFF) << 16) + (long)((this.buffer[this.bufferPosition + 6] & 0xFF) << 8) + (long)((this.buffer[this.bufferPosition + 7] & 0xFF) << 0);
        this.bufferPosition += 8;
        return result;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    protected int readIntArray(int[] a) throws IOException {
        int i = 0;
        while (i < a.length) {
            a[i] = this.readInt();
            ++i;
        }
        return a.length;
    }

    protected int readLongArray(long[] a) throws IOException {
        int i = 0;
        while (i < a.length) {
            a[i] = this.readLong();
            ++i;
        }
        return a.length;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return 0xFFFFFFFFL & (long)this.readInt();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
        this.channelPosition = pos;
        this.bufferLength = 0;
        this.bufferPosition = 0;
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readID(int idSize) throws IOException {
        return idSize == 4 ? 0xFFFFFFFFL & (long)this.readInt() : this.readLong();
    }
}

