/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.handle;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.net.api.handle.Chore;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.handle.Failure;
import org.eclipse.passage.lic.internal.net.handle.ProductUserRequest;

public abstract class ChoreDraft<R extends NetRequest>
implements Chore {
    protected final R data;
    protected final Logger log = LogManager.getLogger(this.getClass());

    protected ChoreDraft(R request) {
        this.data = request;
    }

    @Override
    public final NetResponse getDone() {
        ProductUserRequest<R> request;
        Optional<NetResponse> error = this.invalid();
        if (error.isPresent()) {
            return error.get();
        }
        try {
            request = new ProductUserRequest<R>(this.data);
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return this.failed(e.getMessage());
        }
        if (!request.product().isPresent()) {
            return new Failure.BadRequestInvalidProduct();
        }
        if (!request.user().isPresent()) {
            return new Failure.BadRequestNoUser();
        }
        try {
            return this.withProductUser(request);
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return this.failed(e.getMessage());
        }
    }

    protected abstract Optional<NetResponse> invalid();

    protected abstract NetResponse withProductUser(ProductUserRequest<R> var1) throws LicensingException;

    protected final NetResponse failed(String details) {
        return new Failure.OperationFailed(this.getClass().getSimpleName(), details);
    }
}

