/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MonitorPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Spinner intervalSpinner;
    private Button forceUpdateButton;

    private GridData createLayoutData(boolean grabHorizontalSpace, boolean grabVerticalSpace, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = grabHorizontalSpace;
        gd.grabExcessVerticalSpace = grabVerticalSpace;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = span;
        return gd;
    }

    private Composite createRowComp(Composite parent, ComponentType type, String text) {
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(10, true);
        result.setLayout((Layout)gridLayout);
        if (type == ComponentType.SPINNER) {
            Label intervalLabel = new Label(result, 0);
            intervalLabel.setText(text);
            intervalLabel.setLayoutData((Object)this.createLayoutData(true, false, 6));
            this.intervalSpinner = new Spinner(result, 0);
            this.intervalSpinner.setValues(60, 1, 3600, 0, 10, 60);
            this.intervalSpinner.setLayoutData((Object)this.createLayoutData(true, false, 4));
            this.intervalSpinner.setToolTipText(Messages.MonitorPreferences_2);
        } else if (type == ComponentType.CHECK) {
            this.forceUpdateButton = new Button(result, 32);
            this.forceUpdateButton.setText(text);
            this.forceUpdateButton.setLayoutData((Object)this.createLayoutData(true, false, 10));
            this.forceUpdateButton.setToolTipText(Messages.MonitorPreferences_3);
        } else if (type == ComponentType.DESCRIPTION) {
            Label descLabel = new Label(result, 0);
            descLabel.setText(text);
            descLabel.setLayoutData((Object)this.createLayoutData(true, false, 10));
        }
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        GridLayout parentLayout = new GridLayout(1, true);
        parent.setLayout((Layout)parentLayout);
        Composite optionComp = new Composite(parent, 0);
        optionComp.setBackground(parent.getDisplay().getSystemColor(9));
        FillLayout fillLayout = new FillLayout(512);
        optionComp.setLayout((Layout)fillLayout);
        optionComp.setLayoutData((Object)this.createLayoutData(true, true, 1));
        this.createRowComp(optionComp, ComponentType.DESCRIPTION, Messages.MonitorPreferences_4);
        this.createRowComp(optionComp, ComponentType.SPINNER, Messages.MonitorPreferences_0);
        this.createRowComp(optionComp, ComponentType.CHECK, Messages.MonitorPreferences_1);
        this.loadData(false);
        return null;
    }

    public void performApply() {
        super.performApply();
        this.saveCurrentData();
        this.loadData(false);
    }

    public void performDefaults() {
        super.performDefaults();
        this.loadData(true);
    }

    public boolean performOk() {
        super.performOk();
        this.saveCurrentData();
        return true;
    }

    public void loadData(boolean defaultValues) {
        IEclipsePreferences currentPref = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.rm.lml.monitor.core");
        IEclipsePreferences defaultPref = DefaultScope.INSTANCE.getNode("org.eclipse.ptp.rm.lml.monitor.core");
        int intervalDefault = defaultPref.getInt("updateInterval", 60);
        int interval = currentPref.getInt("updateInterval", intervalDefault);
        if (defaultValues) {
            interval = intervalDefault;
        }
        this.setInterval(interval);
        boolean defaultForce = defaultPref.getBoolean("forceUpdate", false);
        boolean force = currentPref.getBoolean("forceUpdate", defaultForce);
        if (defaultValues) {
            force = defaultForce;
        }
        this.setForceUpdate(force);
    }

    public void saveCurrentData() {
        if (this.intervalSpinner == null || this.forceUpdateButton == null) {
            return;
        }
        IEclipsePreferences currentPref = InstanceScope.INSTANCE.getNode("org.eclipse.ptp.rm.lml.monitor.core");
        int interval = this.getInterval();
        currentPref.putInt("updateInterval", interval);
        boolean force = this.isForceUpdate();
        currentPref.putBoolean("forceUpdate", force);
    }

    public void setInterval(int interval) {
        if (this.intervalSpinner == null) {
            return;
        }
        if (interval < this.intervalSpinner.getMinimum()) {
            interval = this.intervalSpinner.getMinimum();
        }
        if (interval > this.intervalSpinner.getMaximum()) {
            interval = this.intervalSpinner.getMaximum();
        }
        this.intervalSpinner.setSelection(interval);
    }

    public int getInterval() {
        if (this.intervalSpinner == null) {
            return -1;
        }
        return this.intervalSpinner.getSelection();
    }

    public boolean isForceUpdate() {
        if (this.forceUpdateButton == null) {
            return false;
        }
        return this.forceUpdateButton.getSelection();
    }

    public void setForceUpdate(boolean force) {
        if (this.forceUpdateButton == null) {
            return;
        }
        this.forceUpdateButton.setSelection(force);
    }

    private static enum ComponentType {
        SPINNER,
        CHECK,
        DESCRIPTION;

    }
}

